/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import hidden.jcp.org.apache.commons.lang3.StringEscapeUtils;
import javax.annotation.Nonnull;

public final class FunctionSTR2JAVA
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.BOOLEAN}};

    @Override
    @Nonnull
    public String getName() {
        return "str2java";
    }

    @Nonnull
    public Value executeStrBool(@Nonnull PreprocessorContext context, @Nonnull Value source, @Nonnull Value splitAndQuoteLines) {
        if (splitAndQuoteLines.asBoolean().booleanValue()) {
            boolean endsWithNextLine = source.asString().endsWith("\n");
            String[] splitted = PreprocessorUtils.splitForCharAndHoldEmptyLine(source.asString(), '\n');
            StringBuilder result = new StringBuilder(source.asString().length() * 2);
            String nextLineChars = PreprocessorUtils.getNextLineCodes();
            int index = 0;
            for (String s : splitted) {
                boolean last;
                boolean bl = last = ++index == splitted.length;
                if (result.length() > 0) {
                    result.append(nextLineChars).append('+');
                }
                result.append('\"').append(StringEscapeUtils.escapeJava(s));
                if (last) {
                    result.append(endsWithNextLine ? "\\n\"" : "\"");
                    continue;
                }
                result.append("\\n\"");
            }
            return Value.valueOf(result.toString());
        }
        return Value.valueOf(StringEscapeUtils.escapeJava(source.asString()));
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "escapes a string to be compatible with java";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

