/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;

public final class FunctionSTRLEN
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "strlen";
    }

    @Nonnull
    public Value executeStr(@Nonnull PreprocessorContext context, @Nonnull Value value) {
        return Value.valueOf(Long.valueOf(value.asString().length()));
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "get string length";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.INT;
    }
}

