/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXMLFunction
extends AbstractFunction {
    @Nonnull
    public static String makeElementListId(@Nonnull Element parentName, @Nonnull String elementName) {
        return AbstractXMLFunction.buildPathForElement(parentName) + "_#list_" + elementName;
    }

    @Nonnull
    public static String makeDocumentId(@Nonnull String fileName) {
        return "xmlDocument_" + fileName;
    }

    @Nonnull
    public static String makeDocumentRootId(@Nonnull String documentId) {
        return documentId + "_#root";
    }

    @Nonnull
    public static String makeElementId(@Nonnull String elementListId, @Nonnull int elementIndex) {
        return elementListId + '_' + elementIndex;
    }

    @Nonnull
    public static String makeXPathListId(@Nonnull String documentId, @Nonnull String xpath) {
        return documentId + "_#xpath_" + xpath;
    }

    @Nonnull
    public static String makeXPathElementId(@Nonnull String documentId, @Nonnull String xpath) {
        return documentId + "_#xpathelement_" + xpath;
    }

    @Nonnull
    public String getAttribute(@Nonnull PreprocessorContext context, @Nonnull String elementId, @Nonnull String attributeName) {
        NodeContainer container = (NodeContainer)context.getSharedResource(elementId);
        if (container == null) {
            throw context.makeException("Can't find any active element with the '" + elementId + "' id", null);
        }
        try {
            return ((Element)container.getNode()).getAttribute(attributeName);
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + elementId + '.' + attributeName + ']', ex);
        }
    }

    @Nonnull
    public Document getCachedDocument(@Nonnull PreprocessorContext context, @Nonnull String documentId) {
        NodeContainer container = (NodeContainer)context.getSharedResource(documentId);
        if (container == null) {
            throw context.makeException("Can't find any document for the '" + documentId + "' id", null);
        }
        try {
            return (Document)container.getNode();
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + documentId + ']', ex);
        }
    }

    @Nullable
    public Element findCachedElement(@Nonnull PreprocessorContext context, @Nonnull String elementId) {
        NodeContainer container = (NodeContainer)context.getSharedResource(elementId);
        if (container == null) {
            return null;
        }
        try {
            return (Element)container.getNode();
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + elementId + ']', null);
        }
    }

    @Nonnull
    public Element getCachedElement(@Nonnull PreprocessorContext context, @Nonnull String elementId) {
        Element element = this.findCachedElement(context, elementId);
        if (element == null) {
            throw context.makeException("Can't find any active element for the '" + elementId + "' id", null);
        }
        return element;
    }

    @Nullable
    public NodeList findCachedElementList(@Nonnull PreprocessorContext context, @Nonnull String elementListId) {
        NodeContainer container = (NodeContainer)context.getSharedResource(elementListId);
        if (container == null) {
            return null;
        }
        try {
            return container.getNodeList();
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + elementListId + ']', ex);
        }
    }

    @Nonnull
    public NodeList getCachedElementList(@Nonnull PreprocessorContext context, @Nonnull String elementListId) {
        NodeList result = this.findCachedElementList(context, elementListId);
        if (result == null) {
            throw context.makeException("Can't find any active element list for the '" + elementListId + "' id", null);
        }
        return result;
    }

    public int getElementListSize(@Nonnull PreprocessorContext context, @Nonnull String elementListId) {
        return this.getCachedElementList(context, elementListId).getLength();
    }

    @Nonnull
    public static String buildPathForElement(@Nonnull Element element) {
        StringBuilder result = new StringBuilder();
        for (Node thenode = element; thenode != null; thenode = thenode.getParentNode()) {
            int level = 0;
            for (Node sibling = thenode; sibling != null; sibling = sibling.getPreviousSibling()) {
                ++level;
            }
            result.append('/').append(thenode.getNodeName()).append('{').append(level).append('}');
        }
        return result.toString();
    }

    @Nonnull
    public static String getFirstLevelTextContent(@Nonnull Node node) {
        NodeList list = node.getChildNodes();
        StringBuilder textContent = new StringBuilder(128);
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 3) continue;
            textContent.append(child.getTextContent());
        }
        return textContent.toString();
    }

    @Nonnull
    public String findElementForIndex(@Nonnull PreprocessorContext context, @Nonnull String elementListId, int elementIndex) {
        String elementCacheId = AbstractXMLFunction.makeElementId(elementListId, elementIndex);
        NodeContainer container = (NodeContainer)context.getSharedResource(elementCacheId);
        if (container == null) {
            container = (NodeContainer)context.getSharedResource(elementListId);
            if (container == null) {
                throw context.makeException("Can't find any active node list for the id '" + elementListId + '\'', null);
            }
            NodeList list = container.getNodeList();
            if (elementIndex < 0 || elementIndex >= list.getLength()) {
                throw context.makeException("The Element Index is out of bounds [" + elementIndex + ']', null);
            }
            Element element = (Element)list.item(elementIndex);
            if (element == null) {
                throw context.makeException("Wrong index [" + elementIndex + ']', null);
            }
            container = new NodeContainer(UID_COUNTER.getAndIncrement(), element);
            context.setSharedResource(elementCacheId, container);
        }
        return elementCacheId;
    }
}

