/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.xml.AbstractXMLFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;

public final class FunctionXML_ROOT
extends AbstractXMLFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "xml_root";
    }

    @Nonnull
    public Value executeStr(@Nonnull PreprocessorContext context, @Nonnull Value documentId) {
        String documentRootId = FunctionXML_ROOT.makeDocumentRootId(documentId.asString());
        NodeContainer root = (NodeContainer)context.getSharedResource(documentRootId);
        if (root == null) {
            throw context.makeException("Can't find any root for document [" + documentId + ']', null);
        }
        return Value.valueOf(documentRootId);
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "get the document root element";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

