/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.xml.AbstractXMLFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class FunctionXML_XLIST
extends AbstractXMLFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "xml_xlist";
    }

    @Nonnull
    public Value executeStrStr(@Nonnull PreprocessorContext context, @Nonnull Value documentId, @Nonnull Value xPath) {
        String documentIdStr = documentId.asString();
        String pathStr = xPath.asString();
        String xpathId = FunctionXML_XLIST.makeXPathListId(documentIdStr, pathStr);
        Document document = this.getCachedDocument(context, documentIdStr);
        NodeList list = this.findCachedElementList(context, xpathId);
        if (list == null) {
            try {
                XPathExpression expression = this.prepareXPathExpression(pathStr);
                list = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                throw context.makeException("Error during XPath compilation [" + pathStr + ']', ex);
            }
            NodeContainer container = new NodeContainer(UID_COUNTER.getAndIncrement(), list);
            context.setSharedResource(xpathId, container);
        }
        return Value.valueOf(xpathId);
    }

    @Nonnull
    private XPathExpression prepareXPathExpression(@Nonnull String path) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        return xpath.compile(path);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "get element list for XPath";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

