/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.operators;

import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import javax.annotation.Nonnull;

public final class OperatorADD
extends AbstractOperator {
    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "additive operator (also used for string concatenation)";
    }

    @Override
    @Nonnull
    public String getKeyword() {
        return "+";
    }

    @Nonnull
    public Value executeIntInt(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(arg1.asLong() + arg2.asLong());
    }

    @Nonnull
    public Value executeFloatFloat(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(Float.valueOf(arg1.asFloat().floatValue() + arg2.asFloat().floatValue()));
    }

    @Nonnull
    public Value executeIntFloat(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(Float.valueOf(arg1.asLong().floatValue() + arg2.asFloat().floatValue()));
    }

    @Nonnull
    public Value executeFloatInt(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(Float.valueOf(arg1.asFloat().floatValue() + arg2.asLong().floatValue()));
    }

    @Nonnull
    public Value executeStrAny(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(arg1.asString() + arg2.toString());
    }

    @Nonnull
    public Value executeAnyStr(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(arg1.toString() + arg2.asString());
    }

    @Override
    @Nonnull
    public ExpressionItemPriority getExpressionItemPriority() {
        return ExpressionItemPriority.ARITHMETIC_ADD_SUB;
    }
}

