/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.maven;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

public class MavenPropertiesImporter
implements SpecialVariableProcessor {
    private static final Pattern PATTERN_FOR_PROPERTY_WHICH_CAN_CONTAIN_PRIVATE_INFO = Pattern.compile("key|pass", 2);
    private static final String[] TO_IMPORT = new String[]{"project.name", "project.version", "project.url", "project.packaging", "project.modelVersion", "project.inceptionYear", "project.id", "project.groupId", "project.description", "project.artifact.id", "project.artifact.artifactId", "project.artifact.baseVersion", "project.artifact.dependencyConflictId", "project.artifact.downloadUrl", "project.artifact.groupId", "project.artifact.scope", "project.artifact.type", "project.artifact.version", "project.build.directory", "project.build.defaultGoal", "project.build.outputDirectory", "project.build.scriptSourceDirectory", "project.build.sourceDirectory", "project.build.testOutputDirectory", "project.build.testSourceDirectory", "project.organization.name", "project.organization.url"};
    private final Map<String, Value> insideVarMap = new HashMap<String, Value>();
    private final MavenProject project;

    private void printInfoAboutVarIntoLog(@Nonnull PreprocessorContext context, @Nonnull String varName, @Nonnull String value) {
        boolean possibleContainsPrivateInfo = PATTERN_FOR_PROPERTY_WHICH_CAN_CONTAIN_PRIVATE_INFO.matcher(varName).find();
        String textValue = possibleContainsPrivateInfo ? "***** [hidden because may contain private info]" : value;
        context.logInfo("Added MAVEN property " + varName + '=' + textValue);
    }

    private void addVariableIntoInsideMap(@Nonnull PreprocessorContext context, @Nonnull String name, @Nonnull Value value, boolean verbose) {
        if (this.insideVarMap.containsKey(name)) {
            throw context.makeException("Duplicated importing value detected [" + name + ']', null);
        }
        this.insideVarMap.put(name, value);
        if (verbose) {
            this.printInfoAboutVarIntoLog(context, name, value.asString());
        }
    }

    public MavenPropertiesImporter(@Nonnull PreprocessorContext context, @Nonnull MavenProject project, boolean logAddedProperties) {
        this.project = project;
        for (String paramName : TO_IMPORT) {
            String varName = "mvn." + paramName.toLowerCase(Locale.ENGLISH);
            String value = MavenPropertiesImporter.getProperty(this.project, paramName);
            this.addVariableIntoInsideMap(context, varName, Value.valueOf(value), logAddedProperties);
        }
        StringBuilder profileIds = new StringBuilder();
        for (Profile profile : project.getActiveProfiles()) {
            if (profileIds.length() > 0) {
                profileIds.append(';');
            }
            profileIds.append(profile.getId());
        }
        this.addVariableIntoInsideMap(context, "mvn.project.activeprofiles", Value.valueOf(profileIds.toString()), logAddedProperties);
        for (String propertyName : this.project.getProperties().stringPropertyNames()) {
            String varName = "mvn.project.property." + propertyName.toLowerCase(Locale.ENGLISH).replace(' ', '_');
            String value = this.project.getProperties().getProperty(propertyName);
            this.addVariableIntoInsideMap(context, varName, Value.valueOf(value), logAddedProperties);
        }
    }

    @Nonnull
    static String getProperty(@Nonnull MavenProject project, @Nonnull String name) {
        String[] splitted = name.split("\\.");
        Object root = null;
        if ("project".equals(splitted[0])) {
            root = project;
        }
        try {
            if (root == null) {
                throw new IllegalArgumentException("Unsupported root object detected [" + splitted[0] + ']');
            }
            for (int i = 1; i < splitted.length - 1; ++i) {
                Method getter = root.getClass().getMethod(MavenPropertiesImporter.normalizeGetter(splitted[i]), new Class[0]);
                if ((root = getter.invoke(root, new Object[0])) != null) continue;
                return "";
            }
            Method finalStringGetter = root.getClass().getMethod(MavenPropertiesImporter.normalizeGetter(splitted[splitted.length - 1]), new Class[0]);
            Object result = finalStringGetter.invoke(root, new Object[0]);
            return result == null ? "" : result.toString();
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Can't find method", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Security exception", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Exception during invocation", ex.getCause());
        }
    }

    @Nonnull
    static String normalizeGetter(@Nonnull String str) {
        return "get" + Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getVariableNames() {
        return this.insideVarMap.keySet().toArray(new String[this.insideVarMap.size()]);
    }

    @Override
    @Nullable
    public Value getVariable(@Nonnull String varName, @Nonnull PreprocessorContext context) {
        if (!this.insideVarMap.containsKey(varName)) {
            throw new IllegalArgumentException("Unsupported property request detected [" + varName + ']');
        }
        return this.insideVarMap.get(varName);
    }

    @Override
    public void setVariable(@Nonnull String varName, @Nonnull Value value, @Nonnull PreprocessorContext context) {
        throw new UnsupportedOperationException("An attempt to change a maven property detected, those properties are accessible only for reading [" + varName + ']');
    }
}

