/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.maven;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import hidden.jcp.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

@Mojo(name="clear", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresProject=true)
public class PreprocessorClearMojo
extends AbstractMojo {
    @Parameter(alias="preprocessedSources", readonly=true, defaultValue="${project.build.directory}/generated-sources/preprocessed")
    private File preprocessedSources;
    @Parameter(alias="preprocessedTestSources", readonly=true, defaultValue="${project.build.directory}/generated-test-sources/preprocessed")
    private File preprocessedTestSources;
    @Parameter(alias="fileSets", required=false)
    private List<FileSet> fileSets;

    private void processPredefinedFolders(@Nonnull Log log) throws MojoFailureException {
        String path;
        if (this.preprocessedSources != null) {
            path = this.preprocessedSources.getAbsolutePath();
            log.info((CharSequence)("Removing preprocessed source folder '" + path + '\''));
            if (this.preprocessedSources.isDirectory()) {
                try {
                    FileUtils.deleteDirectory(this.preprocessedSources);
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Can't delete preprocessed source folder", (Throwable)ex);
                }
            } else {
                log.info((CharSequence)("Preprocessed Source folder '" + path + "' doesn't exist"));
            }
        }
        if (this.preprocessedTestSources != null) {
            path = this.preprocessedTestSources.getAbsolutePath();
            log.info((CharSequence)("Removing preprocessed test source folder '" + path + '\''));
            if (this.preprocessedTestSources.isDirectory()) {
                try {
                    FileUtils.deleteDirectory(this.preprocessedTestSources);
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Can't delete preprocessed test source folder", (Throwable)ex);
                }
            } else {
                log.info((CharSequence)("Preprocessed Test Source folder '" + path + "' doesn't exist"));
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Cleaning has been started");
        if (this.fileSets == null) {
            this.processPredefinedFolders(log);
        } else {
            this.processFileSet(this.fileSets, log);
        }
        log.info((CharSequence)"Cleaning has been completed");
    }

    private void processFileSet(@Nonnull @MustNotContainNull List<FileSet> fileSets, @Nonnull Log log) throws MojoExecutionException {
        FileSetManager manager = new FileSetManager(log, true);
        for (FileSet fs : fileSets) {
            try {
                manager.delete(fs, true);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Exception during cleaning", (Exception)ex);
            }
        }
    }
}

