/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.maven;

import com.igormaznitsa.jcp.JCPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.maven.MavenPropertiesImporter;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import hidden.jcp.org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="preprocess", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresProject=true)
public class PreprocessorMojo
extends AbstractMojo
implements PreprocessorLogger {
    @Parameter(alias="compileSourceRoots", defaultValue="${project.compileSourceRoots}", required=true, readonly=true)
    private List<String> compileSourceRoots;
    @Parameter(alias="testCompileSourceRoots", defaultValue="${project.testCompileSourceRoots}", required=true, readonly=true)
    private List<String> testCompileSourceRoots;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(alias="source", defaultValue="")
    private String source;
    @Parameter(alias="copyFileAttributes", defaultValue="false")
    private boolean copyFileAttributes;
    @Parameter(alias="destination", defaultValue="${project.build.directory}/generated-sources/preprocessed")
    private File destination;
    @Parameter(alias="testDestination", defaultValue="${project.build.directory}/generated-test-sources/preprocessed")
    private File testDestination;
    @Parameter(alias="inEncoding", defaultValue="${project.build.sourceEncoding}")
    private String inEncoding;
    @Parameter(alias="outEncoding", defaultValue="${project.build.sourceEncoding}")
    private String outEncoding;
    @Parameter(alias="ignoreMissingSources", defaultValue="false")
    private boolean ignoreMissingSources;
    @Parameter(alias="excluded")
    private String excluded;
    @Parameter(alias="processing")
    private String processing;
    @Parameter(alias="unknownVarAsFalse", defaultValue="false")
    private boolean unknownVarAsFalse;
    @Parameter(alias="disableOut", defaultValue="false")
    private boolean disableOut;
    @Parameter(alias="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(alias="clear", defaultValue="false")
    private boolean clear;
    @Parameter(alias="careForLastNextLine", defaultValue="false")
    private boolean careForLastNextLine;
    @Parameter(alias="keepSrcRoot", defaultValue="false")
    private boolean keepSrcRoot;
    @Parameter(alias="removeComments", defaultValue="false")
    private boolean removeComments;
    @Parameter(alias="globalVars")
    private Properties globalVars;
    @Parameter(alias="excludedFolders")
    private String[] excludedFolders = new String[0];
    @Parameter(alias="cfgFiles")
    private File[] cfgFiles;
    @Parameter(alias="keepLines", defaultValue="true")
    private boolean keepLines;
    @Parameter(alias="allowWhitespace", defaultValue="false")
    private boolean allowWhitespace;
    @Parameter(alias="preserveIndent", defaultValue="false")
    private boolean preserveIndent;
    @Parameter(alias="useTestSources", defaultValue="false")
    private boolean useTestSources;
    @Parameter(alias="skip", property="jcp.preprocess.skip", defaultValue="false")
    private boolean skip;
    @Parameter(alias="compareDestination", defaultValue="false")
    private boolean compareDestination;

    public void setExcludedFolders(String ... antPatterns) {
        this.excludedFolders = (String[])Assertions.assertDoesntContainNull((Object[])Assertions.assertNotNull(antPatterns));
    }

    @Nonnull
    @MustNotContainNull
    public String[] getExcludedFolders() {
        return this.excludedFolders;
    }

    public void setIgnoreMissingSources(boolean flag) {
        this.ignoreMissingSources = flag;
    }

    public boolean isIgnoreMissingSources() {
        return this.ignoreMissingSources;
    }

    public void setSkip(boolean flag) {
        this.skip = flag;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setPreserveIndent(boolean flag) {
        this.preserveIndent = flag;
    }

    public boolean getPreserveIndent() {
        return this.preserveIndent;
    }

    public void setCopyFileAttributes(boolean flag) {
        this.copyFileAttributes = flag;
    }

    public boolean getCopyFileAttributes() {
        return this.copyFileAttributes;
    }

    public void setUseTestSources(boolean flag) {
        this.useTestSources = flag;
    }

    public boolean getUseTestSources() {
        return this.useTestSources;
    }

    public void setClear(boolean flag) {
        this.clear = flag;
    }

    public boolean getClear() {
        return this.clear;
    }

    public void setCareForLastNextLine(boolean flag) {
        this.careForLastNextLine = flag;
    }

    public boolean getCarForLastNextLine() {
        return this.careForLastNextLine;
    }

    public void setKeepSrcRoot(boolean flag) {
        this.keepSrcRoot = flag;
    }

    public boolean getKeepSrcRoot() {
        return this.keepSrcRoot;
    }

    public void setGlobalVars(@Nonnull Properties vars) {
        this.globalVars = vars;
    }

    @Nonnull
    public Properties getGlobalVars() {
        return this.globalVars;
    }

    public void setCfgFiles(@Nonnull @MustNotContainNull File[] files) {
        this.cfgFiles = files;
    }

    @Nonnull
    @MustNotContainNull
    public File[] getCfgFiles() {
        return this.cfgFiles;
    }

    public void setCompareDestination(boolean flag) {
        this.compareDestination = flag;
    }

    public boolean isCompareDestination() {
        return this.compareDestination;
    }

    public void setSource(@Nonnull String source) {
        this.source = source;
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }

    public void setDestination(@Nonnull File destination) {
        this.destination = destination;
    }

    @Nonnull
    public File getDestination() {
        return this.destination;
    }

    public void setTestDestination(@Nonnull File destination) {
        this.testDestination = destination;
    }

    @Nonnull
    public File getTestDestination() {
        return this.testDestination;
    }

    public void setInEncoding(@Nonnull String value) {
        this.inEncoding = value;
    }

    @Nonnull
    public String getInEncoding() {
        return this.inEncoding;
    }

    public void setOutEncoding(@Nonnull String value) {
        this.outEncoding = value;
    }

    @Nonnull
    public String getOutEncoding() {
        return this.outEncoding;
    }

    public void setExcluded(@Nullable String excluded) {
        this.excluded = excluded;
    }

    @Nullable
    public String getExcluded() {
        return this.excluded;
    }

    public void setUnknownVarAsFalse(boolean flag) {
        this.unknownVarAsFalse = flag;
    }

    public boolean getUnknownVarAsFalse() {
        return this.unknownVarAsFalse;
    }

    public void setProcessing(@Nullable String processing) {
        this.processing = processing;
    }

    @Nullable
    public String getProcessing() {
        return this.processing;
    }

    public void setDisableOut(boolean value) {
        this.disableOut = value;
    }

    public boolean getDisableOut() {
        return this.disableOut;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public boolean getKeepLines() {
        return this.keepLines;
    }

    public void setAllowWhitespace(boolean flag) {
        this.allowWhitespace = flag;
    }

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setRemoveComments(boolean value) {
        this.removeComments = value;
    }

    public boolean getRemoveComments() {
        return this.removeComments;
    }

    @Nullable
    private String makeSourceRootList() {
        String result = null;
        if (this.source != null && !this.source.isEmpty()) {
            result = this.source;
        } else if (this.project != null) {
            StringBuilder accum = new StringBuilder();
            for (String srcRoot : this.getUseTestSources() ? this.testCompileSourceRoots : this.compileSourceRoots) {
                Object textToAppend;
                boolean folderPresented = new File(srcRoot).isDirectory();
                if (!folderPresented) {
                    this.getLog().debug((CharSequence)("Can't find source folder : " + srcRoot));
                }
                if ((textToAppend = folderPresented ? srcRoot : (this.isIgnoreMissingSources() ? null : srcRoot)) == null) continue;
                if (accum.length() > 0) {
                    accum.append(';');
                }
                accum.append(srcRoot);
            }
            result = accum.toString();
        }
        return result;
    }

    private void replaceSourceRootByPreprocessingDestinationFolder(@Nonnull PreprocessorContext context) throws IOException {
        if (this.project != null) {
            String sourceDirectories = context.getSourceDirectories();
            String[] splitted = sourceDirectories.split(";");
            List<String> sourceRoots = this.getUseTestSources() ? this.testCompileSourceRoots : this.compileSourceRoots;
            ArrayList<String> sourceRootsAsCanonical = new ArrayList<String>();
            for (String src : sourceRoots) {
                sourceRootsAsCanonical.add(new File(src).getCanonicalPath());
            }
            for (String str : splitted) {
                int index = sourceRoots.indexOf(str);
                if (index < 0) {
                    File src = new File(str);
                    String canonicalPath = src.getCanonicalPath();
                    index = sourceRootsAsCanonical.indexOf(canonicalPath);
                }
                if (index < 0) continue;
                this.info("A Compile source root has been removed from the root list [" + sourceRoots.get(index) + ']');
                sourceRoots.remove(index);
            }
            String destinationDir = context.getDestinationDirectoryAsFile().getCanonicalPath();
            sourceRoots.add(destinationDir);
            this.info("The New compile source root has been added into the list [" + destinationDir + ']');
        }
    }

    @Nonnull
    PreprocessorContext makePreprocessorContext(@Nonnull String sourceFoldersInPreprocessorFormat) throws IOException {
        PreprocessorContext context = new PreprocessorContext();
        context.setPreprocessorLogger(this);
        if (this.project != null) {
            MavenPropertiesImporter mavenPropertiesImporter = new MavenPropertiesImporter(context, this.project, this.getVerbose() || this.getLog().isDebugEnabled());
            context.registerSpecialVariableProcessor(mavenPropertiesImporter);
        }
        context.setSourceDirectories(sourceFoldersInPreprocessorFormat);
        context.setDestinationDirectory(Assertions.assertNotNull(this.getUseTestSources() ? this.testDestination.getCanonicalPath() : this.destination.getCanonicalPath()));
        if (this.inEncoding != null) {
            context.setInCharacterEncoding(this.inEncoding);
        }
        if (this.outEncoding != null) {
            context.setOutCharacterEncoding(this.outEncoding);
        }
        if (this.excluded != null) {
            context.setExcludedFileExtensions(this.excluded);
        }
        if (this.processing != null) {
            context.setProcessingFileExtensions(this.processing);
        }
        this.info("Preprocess sources : " + context.getSourceDirectories());
        this.info("Preprocess destination : " + context.getDestinationDirectory());
        context.setUnknownVariableAsFalse(this.unknownVarAsFalse);
        context.setCompareDestination(this.compareDestination);
        context.setClearDestinationDirBefore(this.clear);
        context.setCareForLastNextLine(this.careForLastNextLine);
        context.setRemoveComments(this.removeComments);
        context.setVerbose(this.getLog().isDebugEnabled() || this.verbose);
        context.setKeepLines(this.keepLines);
        context.setFileOutputDisabled(this.disableOut);
        context.setAllowWhitespace(this.allowWhitespace);
        context.setPreserveIndent(this.preserveIndent);
        context.setExcludedFolderPatterns(this.excludedFolders);
        context.setCopyFileAttributes(this.copyFileAttributes);
        if (this.cfgFiles != null && this.cfgFiles.length != 0) {
            for (File file : this.cfgFiles) {
                Assertions.assertNotNull("Detected null where a config file was expected", file);
                context.addConfigFile(file);
            }
        }
        if (this.globalVars != null && !this.globalVars.isEmpty()) {
            for (String key : this.globalVars.stringPropertyNames()) {
                String value = this.globalVars.getProperty(key);
                Assertions.assertNotNull("Can't find defined value for '" + key + "' global variable", value);
                context.setGlobalVariable(key, Value.recognizeRawString(value));
            }
        }
        return context;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip preprocessing");
        } else {
            PreprocessorContext context = null;
            String sourceFoldersInPreprocessingFormat = this.makeSourceRootList();
            boolean skipPreprocessing = false;
            if (StringUtils.isEmpty(sourceFoldersInPreprocessingFormat)) {
                if (this.isIgnoreMissingSources()) {
                    this.getLog().warn((CharSequence)"Source folders are not provided, preprocessing is skipped.");
                    skipPreprocessing = true;
                } else {
                    throw new MojoFailureException("Can't find source folders to preprocess, check parameters and project type!");
                }
            }
            if (!skipPreprocessing) {
                try {
                    context = this.makePreprocessorContext(Assertions.assertNotNull(sourceFoldersInPreprocessingFormat));
                }
                catch (Exception ex) {
                    PreprocessorException pp = PreprocessorException.extractPreprocessorException(ex);
                    throw new MojoExecutionException(pp == null ? ex.getMessage() : pp.toString(), pp == null ? ex : pp);
                }
                try {
                    JCPreprocessor preprocessor = new JCPreprocessor(context);
                    preprocessor.execute();
                    if (!this.getKeepSrcRoot()) {
                        this.replaceSourceRootByPreprocessingDestinationFolder(context);
                    }
                }
                catch (Exception ex) {
                    PreprocessorException pp = PreprocessorException.extractPreprocessorException(ex);
                    throw new MojoFailureException(pp == null ? ex.getMessage() : PreprocessorException.referenceAsString('.', pp), (Throwable)(pp == null ? ex : pp));
                }
            }
        }
    }

    @Override
    public void error(@Nonnull String message) {
        this.getLog().error((CharSequence)message);
    }

    @Override
    public void info(@Nonnull String message) {
        this.getLog().info((CharSequence)message);
    }

    @Override
    public void warning(@Nonnull String message) {
        this.getLog().warn((CharSequence)message);
    }

    @Override
    public void debug(@Nonnull String message) {
        this.getLog().debug((CharSequence)message);
    }
}

