/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.utils;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.annotation.ThrowsRuntimeException;
import com.igormaznitsa.meta.common.utils.Assertions;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import hidden.jcp.org.apache.commons.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PreprocessorUtils {
    private static final Pattern PATTERN_MACROS_WITH_SPACES = Pattern.compile("\\/\\*\\s*\\$(.*?)\\$\\s*\\*\\/");
    public static final String LINE_END;

    private PreprocessorUtils() {
    }

    @Nullable
    public static String getFileExtension(@Nullable File file) {
        String result = null;
        if (file != null) {
            result = FilenameUtils.getExtension(file.getName());
        }
        return result;
    }

    @Nonnull
    @MustNotContainNull
    @ThrowsRuntimeException(value=NullPointerException.class, reference="if extensions are null")
    public static String[] splitExtensionCommaList(@Nonnull String extensions) {
        String[] result;
        Assertions.assertNotNull("String of extensions is null", extensions);
        String trimmed = extensions.trim();
        if (trimmed.isEmpty()) {
            result = new String[]{};
        } else {
            result = PreprocessorUtils.splitForChar(extensions, ',');
            for (int li = 0; li < result.length; ++li) {
                result[li] = result[li].trim().toLowerCase(Locale.ENGLISH);
            }
        }
        return result;
    }

    @Nonnull
    public static BufferedReader makeFileReader(@Nonnull File file, @Nonnull String charset, int bufferSize) throws IOException {
        Assertions.assertNotNull("File is null", file);
        Assertions.assertNotNull("Charset is null", charset);
        if (!Charset.isSupported(charset)) {
            throw new IllegalArgumentException("Unsupported charset [" + charset + ']');
        }
        BufferedReader result = bufferSize <= 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset), bufferSize);
        return result;
    }

    @Nonnull
    @MustNotContainNull
    public static String[] replaceChar(@Nonnull @MustNotContainNull String[] source, char toBeReplaced, char replacement) {
        String[] result = new String[source.length];
        int index = 0;
        for (String curStr : source) {
            result[index++] = curStr.replace(toBeReplaced, replacement);
        }
        return result;
    }

    @Nonnull
    public static String extractTrimmedTail(@Nonnull String prefix, @Nonnull String value) {
        return PreprocessorUtils.extractTail(prefix, value).trim();
    }

    @Nonnull
    public static String extractTail(@Nonnull String prefix, @Nonnull String value) {
        Assertions.assertNotNull("Prefix is null", prefix);
        Assertions.assertNotNull("Value is null", value);
        if (prefix.length() > value.length()) {
            throw new IllegalArgumentException("Prefix is taller than the value");
        }
        return value.substring(prefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@Nonnull File source, @Nonnull File dest, boolean copyFileAttributes) throws IOException {
        Assertions.assertNotNull("Source is null", source);
        Assertions.assertNotNull("Destination file is null", dest);
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Source file is directory");
        }
        if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new IOException("Can't make directory [" + PreprocessorUtils.getFilePath(dest.getParentFile()) + ']');
        }
        FileChannel fileSrc = null;
        FileChannel fileDst = null;
        FileInputStream fileSrcInput = new FileInputStream(source);
        FileOutputStream fileOutput = null;
        try {
            long written;
            fileSrc = fileSrcInput.getChannel();
            fileOutput = new FileOutputStream(dest);
            fileDst = fileOutput.getChannel();
            long pos = 0L;
            for (long size = fileSrc.size(); size > 0L; size -= written) {
                written = fileSrc.transferTo(pos, size, fileDst);
                pos += written;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileSrcInput);
            IOUtils.closeQuietly(fileOutput);
            IOUtils.closeQuietly(fileDst);
            IOUtils.closeQuietly((Closeable)fileSrc);
            throw throwable;
        }
        IOUtils.closeQuietly(fileSrcInput);
        IOUtils.closeQuietly(fileOutput);
        IOUtils.closeQuietly((Closeable)fileDst);
        IOUtils.closeQuietly((Closeable)fileSrc);
        if (copyFileAttributes) {
            PreprocessorUtils.copyFileAttributes(source, dest);
        }
    }

    public static void copyFileAttributes(@Nonnull File from, @Nonnull File to) {
        to.setExecutable(from.canExecute());
        to.setReadable(from.canRead());
        to.setWritable(from.canWrite());
    }

    @Nonnull
    public static String replacePartByChar(@Nonnull String text, char chr, int startPosition, int length) {
        Assertions.assertTrue("Start position must be great or equals zero", startPosition >= 0);
        Assertions.assertTrue("Length must be great or equals zero", length >= 0);
        StringBuilder result = new StringBuilder(text.length());
        result.append(text.subSequence(0, Math.min(text.length(), startPosition)));
        for (int i = startPosition; i < Math.min(text.length(), startPosition + length); ++i) {
            result.append(chr);
        }
        result.append(text.subSequence(Math.min(startPosition + length, text.length()), text.length()));
        return result.toString();
    }

    @Nonnull
    public static String generateStringForChar(char chr, int length) {
        StringBuilder buffer = new StringBuilder(Math.max(length, 1));
        for (int i = 0; i < length; ++i) {
            buffer.append(chr);
        }
        return buffer.toString();
    }

    @Nonnull
    public static String processMacroses(@Nonnull String processingString, @Nonnull PreprocessorContext context) {
        String result = processingString;
        if (context.isAllowWhitespace()) {
            Matcher matcher = PATTERN_MACROS_WITH_SPACES.matcher(processingString);
            StringBuilder buffer = new StringBuilder();
            int end = 0;
            while (matcher.find()) {
                int start = matcher.start();
                int prevEnd = end;
                end = matcher.end();
                String macrosBody = matcher.group(1);
                Value value = Expression.evalExpression(macrosBody, context);
                buffer.append(processingString.substring(prevEnd, start));
                buffer.append(value.toString());
            }
            if (end < processingString.length()) {
                buffer.append(processingString.substring(end));
            }
            result = buffer.toString();
        } else {
            int position;
            while ((position = result.indexOf("/*$")) >= 0) {
                String leftPart = result.substring(0, position);
                int beginIndex = position;
                if ((position = result.indexOf("$*/", position)) < 0) break;
                String macrosBody = result.substring(beginIndex + 3, position);
                String rightPart = result.substring(position + 3);
                Value value = Expression.evalExpression(macrosBody, context);
                result = leftPart + value.toString() + rightPart;
            }
        }
        return result;
    }

    private static void checkFile(@Nonnull File file) throws IOException {
        Assertions.assertNotNull("File is null", file);
        if (!file.isFile()) {
            throw new FileNotFoundException("File " + PreprocessorUtils.getFilePath(file) + " doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @MustNotContainNull
    public static String[] readWholeTextFileIntoArray(@Nonnull File file, @Nullable String encoding, @Nullable AtomicBoolean endedByNextLine) throws IOException {
        PreprocessorUtils.checkFile(file);
        String enc = encoding == null ? "UTF8" : encoding;
        BufferedReader srcBufferedReader = PreprocessorUtils.makeFileReader(file, enc, (int)file.length());
        ArrayList<String> strContainer = new ArrayList<String>(1024);
        try {
            int chr;
            StringBuilder buffer = new StringBuilder();
            boolean stringEndedByNextLine = false;
            boolean meetCR = false;
            block7: while ((chr = srcBufferedReader.read()) >= 0) {
                switch (chr) {
                    case 10: {
                        stringEndedByNextLine = true;
                        strContainer.add(buffer.toString());
                        buffer.setLength(0);
                        meetCR = false;
                        continue block7;
                    }
                    case 13: {
                        if (meetCR) {
                            buffer.append((char)chr);
                            continue block7;
                        }
                        stringEndedByNextLine = false;
                        meetCR = true;
                        continue block7;
                    }
                }
                if (meetCR) {
                    buffer.append('\r');
                }
                meetCR = false;
                stringEndedByNextLine = false;
                buffer.append((char)chr);
            }
            if (buffer.length() != 0) {
                strContainer.add(buffer.toString());
                buffer.setLength(0);
            }
            if (endedByNextLine != null) {
                endedByNextLine.set(stringEndedByNextLine);
            }
        }
        finally {
            srcBufferedReader.close();
        }
        return strContainer.toArray(new String[strContainer.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static byte[] readFileAsByteArray(@Nonnull File file) throws IOException {
        int len;
        PreprocessorUtils.checkFile(file);
        ByteBuffer buffer = ByteBuffer.allocate(len);
        FileChannel inChannel = new FileInputStream(file).getChannel();
        try {
            int read;
            for (len = (int)file.length(); len > 0; len -= read) {
                read = inChannel.read(buffer);
                if (read >= 0) continue;
                throw new IOException("Can't read whole file [" + PreprocessorUtils.getFilePath(file) + '\'');
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)inChannel);
        }
        return buffer.array();
    }

    @Nonnull
    @MustNotContainNull
    public static String[] splitForEqualChar(@Nonnull String string) {
        String[] result;
        int index = string.indexOf(61);
        if (index < 0) {
            result = new String[]{string};
        } else {
            String leftPart = string.substring(0, index).trim();
            String rightPart = string.substring(index + 1).trim();
            result = new String[]{leftPart, rightPart};
        }
        return result;
    }

    @Nonnull
    @MustNotContainNull
    public static String[] splitForCharAndHoldEmptyLine(@Nonnull String string, char delimiter) {
        String[] stringArray;
        String[] result = PreprocessorUtils.splitForChar(string, delimiter);
        if (result.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = result;
        }
        return stringArray;
    }

    @Nonnull
    @MustNotContainNull
    public static String[] splitForChar(@Nonnull String string, char delimiter) {
        char[] array = string.toCharArray();
        StringBuilder buffer = new StringBuilder(array.length >> 1 == 0 ? 1 : array.length >> 1);
        ArrayList<String> tokens = new ArrayList<String>(10);
        for (char curChar : array) {
            if (curChar == delimiter) {
                if (buffer.length() == 0) continue;
                tokens.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(curChar);
        }
        if (buffer.length() != 0) {
            tokens.add(buffer.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    @Nullable
    public static String normalizeVariableName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return name.trim().toLowerCase(Locale.ENGLISH);
    }

    @Nonnull
    public static String getFilePath(@Nullable File file) {
        String result = "";
        if (file != null) {
            try {
                result = file.getCanonicalPath();
            }
            catch (IOException ex) {
                result = file.getAbsolutePath();
            }
        }
        return result;
    }

    public static void throwPreprocessorException(@Nullable String msg, @Nullable String processingString, @Nonnull File srcFile, int nextStringIndex, @Nullable Throwable cause) {
        throw new PreprocessorException(msg, processingString, new FilePositionInfo[]{new FilePositionInfo(srcFile, nextStringIndex)}, cause);
    }

    @Nonnull
    @MustNotContainNull
    public static String[] replaceStringPrefix(@Nonnull @MustNotContainNull String[] allowedPrefixesToBeReplaced, @Nonnull String replacement, @Nonnull @MustNotContainNull String[] strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            String detectedPrefix = null;
            for (String prefix : allowedPrefixesToBeReplaced) {
                if (!str.startsWith(prefix) || detectedPrefix != null && detectedPrefix.length() >= prefix.length()) continue;
                detectedPrefix = prefix;
            }
            result[i] = detectedPrefix != null ? replacement + str.substring(detectedPrefix.length()) : str;
        }
        return result;
    }

    @Nonnull
    public static String getNextLineCodes() {
        return System.getProperty("line.separator", "\r\n");
    }

    @Nonnull
    public static String leftTrim(@Nonnull String rawString) {
        char ch;
        int firstNonSpace = 0;
        for (int i = 0; i < rawString.length() && (ch = rawString.charAt(i)) <= ' '; ++i) {
            ++firstNonSpace;
        }
        return rawString.substring(firstNonSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileContentEquals(@Nullable File src, @Nullable File dst) throws IOException {
        if (src == null && dst == null) {
            return true;
        }
        if (src == null || dst == null) {
            return false;
        }
        if (src.isDirectory() && dst.isDirectory()) {
            return true;
        }
        if (src.isDirectory() || dst.isDirectory()) {
            return false;
        }
        if (src.length() != dst.length()) {
            return false;
        }
        int bufferSize = Math.min((int)src.length(), 65536);
        byte[] srcBuffer = new byte[bufferSize];
        byte[] dstBuffer = new byte[bufferSize];
        BufferedInputStream srcIn = new BufferedInputStream(new FileInputStream(src), bufferSize);
        BufferedInputStream dstIn = new BufferedInputStream(new FileInputStream(dst), bufferSize);
        try {
            while (true) {
                int readSrc = IOUtils.read(srcIn, srcBuffer);
                int readDst = IOUtils.read(dstIn, dstBuffer);
                if (readDst != readSrc) {
                    boolean bl = false;
                    return bl;
                }
                if (readSrc == 0) break;
                if (Arrays.equals(srcBuffer, dstBuffer)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(srcIn);
            IOUtils.closeQuietly(dstIn);
        }
    }

    static {
        String jcpLlineEnd = System.getProperty("jcp.line.separator");
        LINE_END = jcpLlineEnd == null ? System.getProperty("line.separator", "\r\n") : jcpLlineEnd;
    }
}

