/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.exceptions;

import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.common.exceptions.MetaErrorListener;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Weight(value=Weight.Unit.NORMAL)
public final class MetaErrorListeners {
    private static final List<MetaErrorListener> ERROR_LISTENERS = new CopyOnWriteArrayList<MetaErrorListener>();

    private MetaErrorListeners() {
    }

    public static void clear() {
        ERROR_LISTENERS.clear();
    }

    public static void addErrorListener(@Nonnull MetaErrorListener value) {
        ERROR_LISTENERS.add(Assertions.assertNotNull(value));
    }

    public static void removeErrorListener(@Nonnull MetaErrorListener value) {
        ERROR_LISTENERS.remove(Assertions.assertNotNull(value));
    }

    public static boolean hasListeners() {
        return !ERROR_LISTENERS.isEmpty();
    }

    @Weight(value=Weight.Unit.VARIABLE)
    public static void fireError(@Nonnull String text, @Nonnull Throwable error) {
        for (MetaErrorListener p : ERROR_LISTENERS) {
            p.onDetectedError(text, error);
        }
    }
}

