/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.annotation.Warning;
import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.common.exceptions.MetaErrorListeners;
import com.igormaznitsa.meta.common.exceptions.UnexpectedProcessingError;
import com.igormaznitsa.meta.common.interfaces.Disposable;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.IOUtils;
import com.igormaznitsa.meta.common.utils.ThreadUtils;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class Deferrers {
    @MustNotContainNull
    private static final ThreadLocal<List<Deferred>> REGISTRY = new ThreadLocal<List<Deferred>>(){

        @Override
        protected List<Deferred> initialValue() {
            return new ArrayList<Deferred>();
        }
    };

    private Deferrers() {
    }

    @Weight(value=Weight.Unit.NORMAL)
    public static Deferred defer(@Nonnull Deferred deferred) {
        REGISTRY.get().add(Assertions.assertNotNull(deferred));
        return deferred;
    }

    @Warning(value="Using reflection")
    @Weight(value=Weight.Unit.NORMAL)
    public static <T> T deferredClose(final @Nullable T closeable) {
        if (closeable != null) {
            Deferrers.defer(new Deferred(){
                private static final long serialVersionUID = 2265124256013043847L;

                @Override
                public void executeDeferred() throws Exception {
                    try {
                        closeable.getClass().getMethod("close", new Class[0]).invoke(closeable, new Object[0]);
                    }
                    catch (Exception thr) {
                        MetaErrorListeners.fireError("Error during deferred closing action", thr);
                    }
                }
            });
        }
        return closeable;
    }

    @Weight(value=Weight.Unit.NORMAL)
    public static <T extends Closeable> T defer(final @Nullable T closeable) {
        if (closeable != null) {
            Deferrers.defer(new Deferred(){
                private static final long serialVersionUID = 2265124256013043847L;

                @Override
                public void executeDeferred() throws Exception {
                    IOUtils.closeQuetly(closeable);
                }
            });
        }
        return closeable;
    }

    @Weight(value=Weight.Unit.NORMAL)
    public static Runnable defer(final @Nonnull Runnable runnable) {
        Assertions.assertNotNull(runnable);
        Deferrers.defer(new Deferred(){
            private static final long serialVersionUID = 2061489024868070733L;
            private final Runnable value;
            {
                this.value = runnable;
            }

            @Override
            public void executeDeferred() throws Exception {
                this.value.run();
            }
        });
        return runnable;
    }

    @Weight(value=Weight.Unit.NORMAL)
    public static Disposable defer(final @Nonnull Disposable disposable) {
        Assertions.assertNotNull(disposable);
        Deferrers.defer(new Deferred(){
            private static final long serialVersionUID = 7940162959962038010L;
            private final Disposable value;
            {
                this.value = disposable;
            }

            @Override
            public void executeDeferred() throws Exception {
                this.value.dispose();
            }
        });
        return disposable;
    }

    @Weight(value=Weight.Unit.NORMAL)
    public static void cancelAllDeferredActionsGlobally() {
        List<Deferred> list = REGISTRY.get();
        list.clear();
        REGISTRY.remove();
    }

    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void cancelDeferredActions() {
        int stackDepth = ThreadUtils.stackDepth();
        List<Deferred> list = REGISTRY.get();
        Iterator<Deferred> iterator = list.iterator();
        while (iterator.hasNext()) {
            Deferred deferred = iterator.next();
            if (deferred.getStackDepth() < stackDepth) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            REGISTRY.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void processDeferredActions() {
        int stackDepth = ThreadUtils.stackDepth();
        List<Deferred> list = REGISTRY.get();
        Iterator<Deferred> iterator = list.iterator();
        while (iterator.hasNext()) {
            Deferred deferred = iterator.next();
            if (deferred.getStackDepth() < stackDepth) continue;
            try {
                deferred.executeDeferred();
            }
            catch (Exception ex) {
                UnexpectedProcessingError error = new UnexpectedProcessingError("Error during deferred action processing", ex);
                MetaErrorListeners.fireError(error.getMessage(), error);
            }
            finally {
                iterator.remove();
            }
        }
        if (list.isEmpty()) {
            REGISTRY.remove();
        }
    }

    @Weight(value=Weight.Unit.NORMAL)
    public static boolean isEmpty() {
        boolean result = REGISTRY.get().isEmpty();
        if (result) {
            REGISTRY.remove();
        }
        return result;
    }

    @Immutable
    @Weight(value=Weight.Unit.VARIABLE)
    public static abstract class Deferred
    implements Serializable {
        private static final long serialVersionUID = -1134788854676942497L;
        private final int stackDepth = ThreadUtils.stackDepth() - 1;

        @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth@")
        public Deferred() {
        }

        public int getStackDepth() {
            return this.stackDepth;
        }

        public abstract void executeDeferred() throws Exception;
    }
}

