/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.Constraint;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.common.exceptions.MetaErrorListeners;
import com.igormaznitsa.meta.common.exceptions.TimeViolationError;
import com.igormaznitsa.meta.common.exceptions.UnexpectedProcessingError;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.meta.common.utils.ThreadUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TimeGuard {
    public static final TimeAlertListener NULL_TIME_ALERT_LISTENER = new TimeAlertListener(){
        private static final long serialVersionUID = -2291183279100986316L;

        @Override
        public void onTimeAlert(long detectedTimeDelayInMilliseconds, TimeData timeData) {
        }
    };
    @MustNotContainNull
    private static final ThreadLocal<List<TimeData>> REGISTRY = new ThreadLocal<List<TimeData>>(){

        @Override
        protected List<TimeData> initialValue() {
            return new ArrayList<TimeData>();
        }
    };

    private TimeGuard() {
    }

    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void addGuard(@Nullable String alertMessage, @Constraint(value="X>0") long maxAllowedDelayInMilliseconds) {
        List<TimeData> list = REGISTRY.get();
        list.add(new TimeData(ThreadUtils.stackDepth(), alertMessage, maxAllowedDelayInMilliseconds, null));
    }

    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void addPoint(@Nonnull String timePointName, @Nonnull TimeAlertListener listener) {
        List<TimeData> list = REGISTRY.get();
        list.add(new TimeData(ThreadUtils.stackDepth(), timePointName, -1L, Assertions.assertNotNull(listener)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void checkPoint(@Nonnull String timePointName) {
        long time = System.currentTimeMillis();
        int stackDepth = ThreadUtils.stackDepth();
        List<TimeData> list = REGISTRY.get();
        Iterator<TimeData> iterator = list.iterator();
        boolean detected = false;
        while (iterator.hasNext()) {
            TimeData timeWatchItem = iterator.next();
            if (!timeWatchItem.isTimePoint() || timeWatchItem.getDetectedStackDepth() < stackDepth || !timePointName.equals(timeWatchItem.getAlertMessage())) continue;
            detected |= true;
            long detectedDelay = time - timeWatchItem.getCreationTimeInMilliseconds();
            try {
                timeWatchItem.getAlertListener().onTimeAlert(detectedDelay, timeWatchItem);
            }
            catch (Exception ex) {
                UnexpectedProcessingError error = new UnexpectedProcessingError("Error during time point processing", ex);
                MetaErrorListeners.fireError(error.getMessage(), error);
            }
            finally {
                iterator.remove();
            }
        }
        if (!detected) {
            throw new IllegalStateException("Can't find time point [" + timePointName + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void checkPoints() {
        long time = System.currentTimeMillis();
        int stackDepth = ThreadUtils.stackDepth();
        List<TimeData> list = REGISTRY.get();
        Iterator<TimeData> iterator = list.iterator();
        while (iterator.hasNext()) {
            TimeData timeWatchItem = iterator.next();
            if (!timeWatchItem.isTimePoint() || timeWatchItem.getDetectedStackDepth() < stackDepth) continue;
            long detectedDelay = time - timeWatchItem.getCreationTimeInMilliseconds();
            try {
                timeWatchItem.getAlertListener().onTimeAlert(detectedDelay, timeWatchItem);
            }
            catch (Exception ex) {
                UnexpectedProcessingError error = new UnexpectedProcessingError("Error during time point processing", ex);
                MetaErrorListeners.fireError(error.getMessage(), error);
            }
            finally {
                iterator.remove();
            }
        }
    }

    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void addGuard(@Nullable String alertMessage, @Constraint(value="X>0") long maxAllowedDelayInMilliseconds, @Nullable TimeAlertListener timeAlertListener) {
        List<TimeData> list = REGISTRY.get();
        list.add(new TimeData(ThreadUtils.stackDepth(), alertMessage, maxAllowedDelayInMilliseconds, timeAlertListener));
    }

    @Weight(value=Weight.Unit.NORMAL)
    public static void cancelAll() {
        List<TimeData> list = REGISTRY.get();
        list.clear();
        REGISTRY.remove();
    }

    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void cancel() {
        int stackDepth = ThreadUtils.stackDepth();
        List<TimeData> list = REGISTRY.get();
        Iterator<TimeData> iterator = list.iterator();
        while (iterator.hasNext()) {
            TimeData timeWatchItem = iterator.next();
            if (timeWatchItem.getDetectedStackDepth() < stackDepth) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            REGISTRY.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the current call stack depth")
    public static void check() {
        long time = System.currentTimeMillis();
        int stackDepth = ThreadUtils.stackDepth();
        List<TimeData> list = REGISTRY.get();
        Iterator<TimeData> iterator = list.iterator();
        while (iterator.hasNext()) {
            TimeData timeWatchItem = iterator.next();
            if (timeWatchItem.getDetectedStackDepth() < stackDepth) continue;
            boolean timePoint = timeWatchItem.isTimePoint();
            try {
                long detectedDelay = time - timeWatchItem.getCreationTimeInMilliseconds();
                if (timePoint) {
                    try {
                        timeWatchItem.getAlertListener().onTimeAlert(detectedDelay, timeWatchItem);
                    }
                    catch (Exception ex) {
                        UnexpectedProcessingError error = new UnexpectedProcessingError("Error during time point processing", ex);
                        MetaErrorListeners.fireError(error.getMessage(), error);
                    }
                    continue;
                }
                if (detectedDelay <= timeWatchItem.getMaxAllowedDelayInMilliseconds()) continue;
                TimeAlertListener processor = timeWatchItem.getAlertListener();
                if (processor == NULL_TIME_ALERT_LISTENER) {
                    MetaErrorListeners.fireError("Detected time violation without defined time alert listener", (Throwable)((Object)new TimeViolationError(detectedDelay, timeWatchItem)));
                    continue;
                }
                try {
                    processor.onTimeAlert(detectedDelay, timeWatchItem);
                }
                catch (Exception ex) {
                    UnexpectedProcessingError error = new UnexpectedProcessingError("Error during time alert processing", ex);
                    MetaErrorListeners.fireError(error.getMessage(), error);
                }
            }
            finally {
                iterator.remove();
            }
        }
        if (list.isEmpty()) {
            REGISTRY.remove();
        }
    }

    @Weight(value=Weight.Unit.NORMAL, comment="May create list in thread local storage")
    public static boolean isEmpty() {
        boolean result = REGISTRY.get().isEmpty();
        if (result) {
            REGISTRY.remove();
        }
        return result;
    }

    @ThreadSafe
    @Immutable
    public static final class TimeData
    implements Serializable {
        private static final long serialVersionUID = -2417415112571257128L;
        private final int stackDepth;
        private final long maxAllowedDelayInMilliseconds;
        private final long creationTimeInMilliseconds;
        private final String alertMessage;
        private final TimeAlertListener alertListener;

        @Weight(value=Weight.Unit.LIGHT)
        public TimeData(@Constraint(value="X>1") int stackDepth, @Nonnull String alertMessage, long maxAllowedDelayInMilliseconds, @Nullable TimeAlertListener violationListener) {
            this.stackDepth = stackDepth;
            this.maxAllowedDelayInMilliseconds = maxAllowedDelayInMilliseconds;
            this.creationTimeInMilliseconds = System.currentTimeMillis();
            this.alertMessage = alertMessage;
            this.alertListener = GetUtils.ensureNonNull(violationListener, NULL_TIME_ALERT_LISTENER);
        }

        @Nonnull
        public TimeAlertListener getAlertListener() {
            return this.alertListener;
        }

        @Nullable
        public String getAlertMessage() {
            return this.alertMessage;
        }

        public int getDetectedStackDepth() {
            return this.stackDepth;
        }

        public long getCreationTimeInMilliseconds() {
            return this.creationTimeInMilliseconds;
        }

        public long getMaxAllowedDelayInMilliseconds() {
            return this.maxAllowedDelayInMilliseconds;
        }

        public boolean isTimePoint() {
            return this.maxAllowedDelayInMilliseconds < 0L;
        }
    }

    @ThreadSafe
    @Weight(value=Weight.Unit.EXTRALIGHT)
    public static interface TimeAlertListener
    extends Serializable {
        public void onTimeAlert(long var1, @Nonnull TimeData var3);
    }
}

