/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class FileExtensionsHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/F:";

    @Override
    @Nonnull
    public String getDescription() {
        return "comma separated list of allowed extensions (case insensitive) (by default " + PreprocessorContext.DEFAULT_PROCESSING_EXTENSIONS.stream().collect(Collectors.joining(",")) + ')';
    }

    @Override
    public boolean processCommandLineKey(@Nonnull String key, @Nonnull PreprocessorContext context) {
        String extensions;
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(extensions = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty()) {
            context.setExtensions(Arrays.stream(extensions.split("\\,")).map(String::trim).collect(Collectors.toList()));
            result = true;
        }
        return result;
    }

    @Override
    @Nonnull
    public String getKeyName() {
        return ARG_NAME;
    }
}

