/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import javax.annotation.Nonnull;

public class GlobalVariableDefiningFileHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "@";

    @Override
    @Nonnull
    public String getDescription() {
        return "load global variable list from file defined by either path or expression (last one needs @@)";
    }

    @Override
    public boolean processCommandLineKey(@Nonnull String key, @Nonnull PreprocessorContext context) {
        boolean result = false;
        if (!key.isEmpty() && key.charAt(0) == '@') {
            File file;
            String stringRest = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key);
            if (stringRest.isEmpty()) {
                throw context.makeException("Empty string", null);
            }
            if (stringRest.charAt(0) == '@') {
                stringRest = PreprocessorUtils.extractTrimmedTail(ARG_NAME, stringRest);
                if (context.isVerbose()) {
                    context.logForVerbose("Global parameter file defined through expression '" + stringRest + '\'');
                }
                Value resultValue = Expression.evalExpression(stringRest, context);
                String fileName = resultValue.toString();
                file = new File(fileName);
            } else {
                file = new File(stringRest);
            }
            if (context.isVerbose()) {
                context.logForVerbose("Reading global definition file [" + PreprocessorUtils.getFilePath(file) + "]  '" + stringRest + '\'');
            }
            if (!file.isFile()) {
                throw context.makeException("Can't find the global definition file '" + PreprocessorUtils.getFilePath(file) + '\'', null);
            }
            context.registerConfigFile(file);
            result = true;
        }
        return result;
    }

    @Override
    @Nonnull
    public String getKeyName() {
        return ARG_NAME;
    }
}

