/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.Nonnull;

public class InCharsetHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/T:";

    @Override
    @Nonnull
    public String getKeyName() {
        return ARG_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "set the input encoding for text files (by default " + PreprocessorContext.DEFAULT_CHARSET + ')';
    }

    @Override
    public boolean processCommandLineKey(@Nonnull String key, @Nonnull PreprocessorContext context) {
        String value;
        boolean result = false;
        if (key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(value = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty() && Charset.isSupported(value)) {
            context.setSourceEncoding(Charset.forName(value));
            result = true;
        }
        return result;
    }
}

