/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.removers.JavaCommentsRemover;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.jcp.utils.ResetablePrinter;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import hidden.jcp.org.apache.commons.io.FileUtils;
import hidden.jcp.org.apache.commons.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PreprocessingState {
    public static final FilePositionInfo[] EMPTY_STACK = new FilePositionInfo[0];
    public static final int MAX_WRITE_BUFFER_SIZE = 65536;
    private final Charset globalInCharacterEncoding;
    private final Charset globalOutCharacterEncoding;
    private final TextFileDataContainer rootReference;
    private final FileInfoContainer rootFileInfo;
    private final LinkedList<TextFileDataContainer> whileStack = new LinkedList();
    private final LinkedList<TextFileDataContainer> ifStack = new LinkedList();
    private final LinkedList<TextFileDataContainer> includeStack = new LinkedList();
    private final LinkedList<ExcludeIfInfo> deferredExcludeStack = new LinkedList();
    private final ResetablePrinter prefixPrinter = new ResetablePrinter(1024);
    private final ResetablePrinter postfixPrinter = new ResetablePrinter(65536);
    private final ResetablePrinter normalPrinter = new ResetablePrinter(1024);
    private final boolean overrideOnlyIfContentChanged;
    private final EnumSet<PreprocessingFlag> preprocessingFlags = EnumSet.noneOf(PreprocessingFlag.class);
    private final PreprocessorContext context;
    private final boolean fake;
    private ResetablePrinter currentPrinter;
    private TextFileDataContainer activeIf;
    private TextFileDataContainer activeWhile;
    private String lastReadString;
    private boolean globalPhase;

    PreprocessingState(@Nonnull PreprocessorContext context, @Nonnull Charset inEncoding, @Nonnull Charset outEncoding) {
        this.fake = true;
        this.globalInCharacterEncoding = Assertions.assertNotNull(inEncoding);
        this.globalOutCharacterEncoding = Assertions.assertNotNull(outEncoding);
        this.rootReference = null;
        this.lastReadString = "";
        this.rootFileInfo = new FileInfoContainer(new File("global"), "global", true);
        this.overrideOnlyIfContentChanged = true;
        this.context = context;
        this.init();
    }

    PreprocessingState(@Nonnull PreprocessorContext context, @Nonnull FileInfoContainer rootFile, @Nonnull Charset inEncoding, @Nonnull Charset outEncoding, boolean overrideOnlyIfContentChanged) throws IOException {
        this.fake = false;
        this.context = context;
        this.overrideOnlyIfContentChanged = overrideOnlyIfContentChanged;
        this.globalInCharacterEncoding = Assertions.assertNotNull(inEncoding);
        this.globalOutCharacterEncoding = Assertions.assertNotNull(outEncoding);
        this.rootFileInfo = Assertions.assertNotNull("The root file is null", rootFile);
        this.init();
        this.rootReference = this.openFile(rootFile.getSourceFile());
    }

    PreprocessingState(@Nonnull PreprocessorContext context, @Nonnull FileInfoContainer rootFile, @Nonnull TextFileDataContainer rootContainer, @Nonnull Charset inEncoding, @Nonnull Charset outEncoding, boolean overrideOnlyIfContentChanged) {
        this.fake = false;
        this.context = context;
        this.globalInCharacterEncoding = Assertions.assertNotNull(inEncoding);
        this.globalOutCharacterEncoding = Assertions.assertNotNull(outEncoding);
        this.overrideOnlyIfContentChanged = overrideOnlyIfContentChanged;
        this.rootFileInfo = Assertions.assertNotNull("The root file is null", rootFile);
        this.init();
        this.rootReference = rootContainer;
        this.includeStack.push(rootContainer);
    }

    public void setGlobalPhase(boolean flag) {
        this.globalPhase = flag;
    }

    public boolean isGlobalPhase() {
        return this.globalPhase;
    }

    @Nullable
    public String getLastReadString() {
        return this.lastReadString;
    }

    public void pushExcludeIfData(@Nonnull FileInfoContainer infoContainer, @Nonnull String excludeIfCondition, int stringIndex) {
        Assertions.assertNotNull("File info is null", infoContainer);
        Assertions.assertNotNull("Condition is null", excludeIfCondition);
        if (stringIndex < 0) {
            throw new IllegalArgumentException("Unexpected string index [" + stringIndex + ']');
        }
        this.deferredExcludeStack.push(new ExcludeIfInfo(infoContainer, excludeIfCondition, stringIndex));
    }

    @Nonnull
    @MustNotContainNull
    public List<ExcludeIfInfo> popAllExcludeIfInfoData() {
        ArrayList<ExcludeIfInfo> result = new ArrayList<ExcludeIfInfo>(this.deferredExcludeStack);
        this.deferredExcludeStack.clear();
        return result;
    }

    @Nonnull
    public ExcludeIfInfo popExcludeIfData() {
        return this.deferredExcludeStack.pop();
    }

    @Nonnull
    public Set<PreprocessingFlag> getPreprocessingFlags() {
        return this.preprocessingFlags;
    }

    @Nullable
    public ResetablePrinter getPrinter() throws IOException {
        return this.currentPrinter;
    }

    public void setPrinter(@Nonnull PrinterType type) {
        Assertions.assertNotNull("Type is null", type);
        switch (type) {
            case NORMAL: {
                this.currentPrinter = this.normalPrinter;
                break;
            }
            case POSTFIX: {
                this.currentPrinter = this.postfixPrinter;
                break;
            }
            case PREFIX: {
                this.currentPrinter = this.prefixPrinter;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type detected [" + type.name() + ']');
            }
        }
    }

    @Nonnull
    public TextFileDataContainer getRootTextContainer() {
        return this.rootReference;
    }

    @Nonnull
    public TextFileDataContainer openFile(@Nonnull File file) throws IOException {
        Assertions.assertNotNull("The file is null", file);
        AtomicBoolean endedByNextLineContainer = new AtomicBoolean();
        String[] texts = PreprocessorUtils.readWholeTextFileIntoArray(file, this.globalInCharacterEncoding, endedByNextLineContainer);
        TextFileDataContainer newContainer = new TextFileDataContainer(file, texts, endedByNextLineContainer.get(), 0);
        this.includeStack.push(newContainer);
        return newContainer;
    }

    @Nullable
    public TextFileDataContainer peekFile() {
        return this.includeStack.peek();
    }

    @Nonnull
    @MustNotContainNull
    List<TextFileDataContainer> getCurrentIncludeStack() {
        return this.includeStack;
    }

    @Nonnull
    @MustNotContainNull
    public FilePositionInfo[] makeIncludeStack() {
        if (this.fake) {
            return EMPTY_STACK;
        }
        FilePositionInfo[] stack = new FilePositionInfo[this.includeStack.size()];
        for (int i = 0; i < this.includeStack.size(); ++i) {
            TextFileDataContainer fileContainer = this.includeStack.get(i);
            stack[i] = new FilePositionInfo(fileContainer.getFile(), fileContainer.getLastReadStringIndex());
        }
        return stack;
    }

    @Nullable
    public TextFileDataContainer getCurrentIncludeFileContainer() {
        return this.includeStack.isEmpty() ? null : this.includeStack.get(this.includeStack.size() - 1);
    }

    @Nonnull
    public TextFileDataContainer popTextContainer() {
        if (this.includeStack.isEmpty()) {
            throw new IllegalStateException("Include stack is empty");
        }
        return this.includeStack.pop();
    }

    @Nonnull
    public FileInfoContainer getRootFileInfo() {
        return this.rootFileInfo;
    }

    public boolean isIncludeStackEmpty() {
        return this.includeStack.isEmpty();
    }

    public boolean isOnlyRootOnStack() {
        return this.includeStack.size() == 1;
    }

    @Nonnull
    private TextFileDataContainer cloneTopTextDataContainer(boolean useLastReadStringIndex) {
        TextFileDataContainer topElement = this.includeStack.peek();
        return new TextFileDataContainer(topElement, useLastReadStringIndex ? topElement.getLastReadStringIndex() : topElement.getNextStringIndex());
    }

    @Nonnull
    public PreprocessingState popWhile() {
        TextFileDataContainer whileOnTop = this.whileStack.pop();
        if (whileOnTop == this.activeWhile) {
            this.preprocessingFlags.remove((Object)PreprocessingFlag.BREAK_COMMAND);
            this.activeWhile = this.whileStack.isEmpty() ? null : this.whileStack.peek();
        }
        return this;
    }

    @Nonnull
    public PreprocessingState pushWhile(boolean makeActive) {
        TextFileDataContainer whileRef = this.cloneTopTextDataContainer(true);
        this.whileStack.push(whileRef);
        if (makeActive) {
            this.activeWhile = whileRef;
        }
        return this;
    }

    @Nullable
    public TextFileDataContainer peekWhile() {
        return this.whileStack.peek();
    }

    public boolean hasReadLineNextLineInEnd() {
        return this.includeStack.peek().isPresentedNextLineOnReadString();
    }

    @Nullable
    public String nextLine() {
        String result;
        this.lastReadString = result = this.includeStack.peek().nextLine();
        return result;
    }

    @Nonnull
    public PreprocessingState goToString(int stringIndex) {
        this.includeStack.peek().setNextStringIndex(stringIndex);
        return this;
    }

    @Nonnull
    public PreprocessingState pushIf(boolean makeActive) {
        TextFileDataContainer ifRef = this.cloneTopTextDataContainer(true);
        this.ifStack.push(ifRef);
        if (makeActive) {
            this.activeIf = ifRef;
        }
        return this;
    }

    public void popAllIFUntilContainerWithFile(@Nonnull TextFileDataContainer container) {
        TextFileDataContainer top;
        File file = container.getFile();
        int stringIndex = container.getNextStringIndex();
        while (!this.ifStack.isEmpty() && (top = this.ifStack.peek()).getFile().equals(file) && top.getNextStringIndex() > stringIndex) {
            this.ifStack.pop();
        }
    }

    @Nonnull
    public PreprocessingState popIf() {
        TextFileDataContainer ifRef = this.ifStack.pop();
        if (ifRef == this.activeIf) {
            this.activeIf = this.ifStack.isEmpty() ? null : this.ifStack.peek();
        }
        return this;
    }

    public boolean isAtActiveWhile() {
        if (this.whileStack.isEmpty()) {
            return true;
        }
        return this.activeWhile == this.whileStack.peek();
    }

    public boolean isAtActiveIf() {
        if (this.ifStack.isEmpty()) {
            return true;
        }
        return this.ifStack.peek() == this.activeIf;
    }

    public boolean isDirectiveCanBeProcessedIgnoreBreak() {
        return this.isAtActiveIf() && this.isAtActiveWhile() && !this.preprocessingFlags.contains((Object)PreprocessingFlag.IF_CONDITION_FALSE);
    }

    public boolean isDirectiveCanBeProcessed() {
        return this.isDirectiveCanBeProcessedIgnoreBreak() && !this.preprocessingFlags.contains((Object)PreprocessingFlag.BREAK_COMMAND);
    }

    @Nullable
    public TextFileDataContainer peekIf() {
        return this.ifStack.peek();
    }

    public boolean isIfStackEmpty() {
        return this.ifStack.isEmpty();
    }

    public boolean isWhileStackEmpty() {
        return this.whileStack.isEmpty();
    }

    private void init() {
        this.preprocessingFlags.clear();
        this.resetPrinters();
        this.setPrinter(PrinterType.NORMAL);
    }

    public void resetPrinters() {
        this.normalPrinter.reset();
        this.prefixPrinter.reset();
        this.postfixPrinter.reset();
        this.currentPrinter = this.normalPrinter;
    }

    public void saveBuffersToStreams(@Nonnull OutputStream prefix, @Nonnull OutputStream normal, @Nonnull OutputStream postfix) throws IOException {
        this.prefixPrinter.writeBufferTo(new BufferedWriter(new OutputStreamWriter(prefix, this.globalOutCharacterEncoding)));
        this.normalPrinter.writeBufferTo(new BufferedWriter(new OutputStreamWriter(normal, this.globalOutCharacterEncoding)));
        this.postfixPrinter.writeBufferTo(new BufferedWriter(new OutputStreamWriter(postfix, this.globalOutCharacterEncoding)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveBuffersToFile(@Nonnull File outFile, boolean keepComments) throws IOException {
        boolean wasSaved;
        OutputStreamWriter writer;
        block16: {
            File path = outFile.getParentFile();
            if (path != null && !path.exists() && !path.mkdirs()) {
                throw new IOException("Can't make directory [" + PreprocessorUtils.getFilePath(path) + ']');
            }
            writer = null;
            wasSaved = false;
            try {
                int totatBufferedChars = this.prefixPrinter.getSize() + this.normalPrinter.getSize() + this.postfixPrinter.getSize();
                int BUFFER_SIZE = Math.max(64, Math.min(totatBufferedChars << 1, 65536));
                if (this.overrideOnlyIfContentChanged) {
                    String content = this.writePrinterBuffers(new StringWriter(totatBufferedChars)).toString();
                    if (!keepComments) {
                        content = new JavaCommentsRemover(new StringReader(content), new StringWriter(totatBufferedChars)).process().toString();
                    }
                    boolean needWrite = true;
                    byte[] contentInBinaryForm = content.getBytes(this.globalOutCharacterEncoding);
                    if (outFile.isFile() && outFile.length() == (long)contentInBinaryForm.length) {
                        try (BufferedInputStream currentFileInputStream = new BufferedInputStream(new FileInputStream(outFile), Math.max(16384, (int)outFile.length()));){
                            needWrite = !IOUtils.contentEquals(currentFileInputStream, new ByteArrayInputStream(contentInBinaryForm));
                        }
                    }
                    if (needWrite) {
                        FileUtils.writeByteArrayToFile(outFile, contentInBinaryForm, false);
                        wasSaved = true;
                    } else {
                        this.context.logDebug("Ignore writing data for " + outFile + " because its content has not been changed");
                    }
                    break block16;
                }
                if (!keepComments) {
                    String joinedBufferContent = this.writePrinterBuffers(new StringWriter(totatBufferedChars)).toString();
                    writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile, false), BUFFER_SIZE), this.globalOutCharacterEncoding);
                    new JavaCommentsRemover(new StringReader(joinedBufferContent), writer).process();
                    wasSaved = true;
                    break block16;
                }
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile, false), BUFFER_SIZE), this.globalOutCharacterEncoding);
                this.writePrinterBuffers(writer);
                wasSaved = true;
            }
            catch (Throwable throwable) {
                com.igormaznitsa.meta.common.utils.IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        com.igormaznitsa.meta.common.utils.IOUtils.closeQuietly(writer);
        if (wasSaved && this.context.isKeepAttributes() && outFile.exists()) {
            PreprocessorUtils.copyFileAttributes(this.getRootFileInfo().getSourceFile(), outFile);
        }
        return wasSaved;
    }

    @Nonnull
    public Writer writePrinterBuffers(@Nonnull Writer writer) throws IOException {
        if (!this.prefixPrinter.isEmpty()) {
            this.prefixPrinter.writeBufferTo(writer);
        }
        if (!this.normalPrinter.isEmpty()) {
            this.normalPrinter.writeBufferTo(writer);
        }
        if (!this.postfixPrinter.isEmpty()) {
            this.postfixPrinter.writeBufferTo(writer);
        }
        return writer;
    }

    @Nonnull
    public PreprocessorException makeException(@Nullable String message, @Nullable String causeString, @Nullable Throwable cause) {
        return new PreprocessorException(message, causeString, this.makeIncludeStack(), cause);
    }

    public static class ExcludeIfInfo {
        private final FileInfoContainer fileInfoContainer;
        private final String condition;
        private final int stringIndex;

        public ExcludeIfInfo(@Nonnull FileInfoContainer fileInfoContainer, @Nonnull String condition, int stringIndex) {
            this.fileInfoContainer = fileInfoContainer;
            this.condition = condition.trim();
            this.stringIndex = stringIndex;
        }

        public int getStringIndex() {
            return this.stringIndex;
        }

        @Nonnull
        public FileInfoContainer getFileInfoContainer() {
            return this.fileInfoContainer;
        }

        @Nonnull
        public String getCondition() {
            return this.condition;
        }
    }

    public static enum PrinterType {
        NORMAL,
        PREFIX,
        POSTFIX;

    }
}

