/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.ExpressionParser;
import com.igormaznitsa.jcp.expression.ExpressionTree;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.Variable;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.IOException;
import javax.annotation.Nonnull;

public class DefineDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "define";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.TAIL;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "add global BOOL variable and either set it TRUE (by default) or initialize by expression result";
    }

    protected void process(@Nonnull PreprocessorContext context, @Nonnull String varName, @Nonnull Value value, boolean exists) {
        if (exists) {
            context.logWarning("Variable '" + varName + "' already defined");
        }
        context.setGlobalVariable(varName, value);
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String rawTail, @Nonnull PreprocessorContext context) {
        try {
            String expression;
            String name;
            String trimmedTail = rawTail.trim();
            int spaceIndex = trimmedTail.indexOf(32);
            if (spaceIndex > 0) {
                name = trimmedTail.substring(0, spaceIndex).trim();
                String trimmed = trimmedTail.substring(spaceIndex).trim();
                expression = trimmed.isEmpty() || trimmed.startsWith("//") || trimmed.startsWith("/*") ? null : trimmed;
            } else {
                name = trimmedTail;
                expression = null;
            }
            ExpressionTree nameTree = ExpressionParser.getInstance().parse(name, context);
            if (nameTree.isEmpty()) {
                throw context.makeException("Var name is empty", null);
            }
            ExpressionItem item = Assertions.assertNotNull(nameTree.getRoot().getItem());
            if (item.getExpressionItemType() != ExpressionItemType.VARIABLE) {
                throw context.makeException("Can't recognize variable name [" + name + ']', null);
            }
            Value value = expression != null ? Expression.evalExpression(expression, context) : Value.valueOf(Boolean.TRUE);
            this.process(context, ((Variable)item).getName(), value, context.findVariableForName(name, true) != null);
        }
        catch (IOException ex) {
            throw context.makeException("Unexpected exception", ex);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

