/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import javax.annotation.Nonnull;

public class ErrorDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "error";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.EXPRESSTION;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "throw fatal preprocessor exception with message and stop work";
    }

    protected void process(@Nonnull PreprocessorContext context, @Nonnull String message) {
        String text = PreprocessorUtils.processMacroses(message, context);
        context.logError(text);
        throw context.makeException(text, null);
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String trimmedString, @Nonnull PreprocessorContext context) {
        String message = trimmedString.isEmpty() ? "Thrown fatal error" : Expression.evalExpression(trimmedString, context).toString();
        this.process(context, message);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

