/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import javax.annotation.Nonnull;

public class GlobalDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "global";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.SET;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        this.processDefinition(string, context);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "define global variable";
    }

    @Override
    public boolean isGlobalPhaseAllowed() {
        return true;
    }

    @Override
    public boolean isPreprocessingPhaseAllowed() {
        return false;
    }

    private void processDefinition(@Nonnull String string, @Nonnull PreprocessorContext context) {
        String[] split = PreprocessorUtils.splitForEqualChar(string);
        if (split.length != 2) {
            throw context.makeException("Can't find expression [" + string + ']', null);
        }
        String name = split[0].trim();
        Value newValue = Expression.evalExpression(split[1].trim(), context);
        context.setGlobalVariable(name, newValue);
    }
}

