/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;

public class NoAutoFlushHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "noautoflush";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "turn off auto-flush when EOF";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (context.isVerbose()) {
            context.logForVerbose("Disabling auto-flush");
        }
        Assertions.assertNotNull("File stack is empty!", state.peekFile()).disableAutoFlush();
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

