/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import javax.annotation.Nonnull;

public class OutNameDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "outname";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "change target file name (same as change 'jcp.dst.name')";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.STRING;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        Value fileName = Expression.evalExpression(string, context);
        String fileNameAsStr = fileName.toString();
        if (context.isVerbose()) {
            context.logForVerbose("Change target file name to '" + fileNameAsStr + "'");
        }
        context.getPreprocessingState().getRootFileInfo().setTargetFileName(fileNameAsStr);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

