/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import javax.annotation.Nonnull;

public class PrefixDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "prefix";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "turn on(+) or turn off(-) output into prefix section";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.ONOFF;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case '+': {
                    state.setPrinter(PreprocessingState.PrinterType.PREFIX);
                    break;
                }
                case '-': {
                    state.setPrinter(PreprocessingState.PrinterType.NORMAL);
                    break;
                }
                default: {
                    throw context.makeException("Unsupported ending [" + string + ']', null);
                }
            }
            return AfterDirectiveProcessingBehaviour.PROCESSED;
        }
        throw context.makeException(this.getFullName() + " needs ending [+|-]", null);
    }
}

