/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.DefineDirectiveHandler;
import com.igormaznitsa.jcp.expression.Value;
import javax.annotation.Nonnull;

public class UndefDirectiveHandler
extends DefineDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "undef";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "remove definition of existing variable from context";
    }

    @Override
    protected void process(@Nonnull PreprocessorContext context, @Nonnull String varName, @Nonnull Value value, boolean exists) {
        if (context.isLocalVariable(varName)) {
            context.removeLocalVariable(varName);
        } else if (context.isGlobalVariable(varName)) {
            context.removeGlobalVariable(varName);
        } else {
            throw context.makeException("Attempting to undefine unknown variable '" + value + "'", null);
        }
    }
}

