/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.exceptions;

import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PreprocessorException
extends RuntimeException {
    private static final long serialVersionUID = 2857499664112391862L;
    private final String processingString;
    private final transient FilePositionInfo[] includeStack;

    public PreprocessorException(@Nullable String message, @Nullable String processedText, @Nullable @MustNotContainNull FilePositionInfo[] includeStack, @Nullable Throwable cause) {
        super(message, cause);
        this.processingString = processedText;
        this.includeStack = includeStack == null ? new FilePositionInfo[]{} : (FilePositionInfo[])includeStack.clone();
    }

    @Nonnull
    private static String makeStackView(@Nullable @MustNotContainNull FilePositionInfo[] list, char fill) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int tab = 5;
        for (int s = 0; s < tab; ++s) {
            builder.append(fill);
        }
        builder.append("{File chain}");
        tab += 5;
        int fileIndex = 1;
        for (int i = list.length - 1; i >= 0; --i) {
            FilePositionInfo cur = list[i];
            builder.append('\n');
            for (int s = 0; s < tab; ++s) {
                builder.append(fill);
            }
            builder.append("\u2514>");
            builder.append(fileIndex++).append(". ");
            builder.append(cur.getFile().getName()).append(':').append(cur.getLineNumber());
            tab += 3;
        }
        return builder.toString();
    }

    @Nullable
    public static PreprocessorException extractPreprocessorException(@Nullable Throwable thr) {
        if (thr == null) {
            return null;
        }
        Throwable result = thr;
        do {
            if (!(result instanceof PreprocessorException)) continue;
            return (PreprocessorException)result;
        } while ((result = result.getCause()) != null);
        return null;
    }

    @Nonnull
    public static String referenceAsString(char fillChar, @Nullable Throwable thr) {
        if (thr == null) {
            return "";
        }
        StringWriter buffer = new StringWriter(1024);
        PrintWriter out = new PrintWriter(buffer);
        PreprocessorException pp = PreprocessorException.extractPreprocessorException(thr);
        if (pp == null) {
            out.println(thr.getMessage());
            thr.printStackTrace(out);
        } else {
            out.println(pp.getMessage());
            out.println(PreprocessorException.makeStackView(pp.getIncludeChain(), fillChar));
            if (pp.getCause() != null) {
                pp.getCause().printStackTrace(out);
            }
        }
        return buffer.toString();
    }

    @Nullable
    public File getRootFile() {
        if (this.includeStack.length == 0) {
            return null;
        }
        return this.includeStack[this.includeStack.length - 1].getFile();
    }

    @Nullable
    public File getProcessingFile() {
        if (this.includeStack.length == 0) {
            return null;
        }
        return this.includeStack[0].getFile();
    }

    public int getLineNumber() {
        if (this.includeStack.length == 0) {
            return -1;
        }
        return this.includeStack[0].getLineNumber();
    }

    @Nullable
    public String getProcessingString() {
        return this.processingString;
    }

    @Nullable
    private String convertIncludeStackToString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.includeStack.length; ++i) {
            if (i > 0) {
                result.append("<-");
            }
            result.append(this.includeStack[i].toString());
        }
        return result.toString();
    }

    @Nonnull
    @MustNotContainNull
    public FilePositionInfo[] getIncludeChain() {
        return (FilePositionInfo[])this.includeStack.clone();
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getMessage() + ", include stack: " + this.convertIncludeStackToString() + ", source line: " + this.processingString;
    }
}

