/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionTreeElement;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpressionTree {
    private final FilePositionInfo[] includeStack;
    private final String sources;
    private ExpressionTreeElement last = ExpressionTreeElement.EMPTY_SLOT;

    public ExpressionTree() {
        this(null, null);
    }

    public ExpressionTree(@Nullable @MustNotContainNull FilePositionInfo[] callStack, @Nullable String sources) {
        this.includeStack = callStack == null ? PreprocessingState.EMPTY_STACK : callStack;
        this.sources = sources == null ? "" : sources;
    }

    public boolean isEmpty() {
        return this.last.isEmptySlot();
    }

    public void addItem(@Nonnull ExpressionItem item) {
        if (item == null) {
            throw new PreprocessorException("[Expression]Item is null", this.sources, this.includeStack, null);
        }
        this.last = this.last.isEmptySlot() ? new ExpressionTreeElement(item, this.includeStack, this.sources) : this.last.addTreeElement(new ExpressionTreeElement(item, this.includeStack, this.sources));
    }

    public void addTree(@Nonnull ExpressionTree tree) {
        Assertions.assertNotNull("Tree is null", tree);
        if (this.last.isEmptySlot()) {
            ExpressionTreeElement thatTreeRoot = tree.getRoot();
            if (!thatTreeRoot.isEmptySlot()) {
                this.last = thatTreeRoot;
                this.last.makeMaxPriority();
            }
        } else {
            this.last = this.last.addSubTree(tree);
        }
    }

    @Nonnull
    public ExpressionTreeElement getRoot() {
        if (this.last.isEmptySlot()) {
            return this.last;
        }
        ExpressionTreeElement element = this.last;
        while (!Thread.currentThread().isInterrupted()) {
            ExpressionTreeElement next = element.getParent();
            if (next == null) {
                return element;
            }
            element = next;
        }
        return ExpressionTreeElement.EMPTY_SLOT;
    }

    public void postProcess() {
        ExpressionTreeElement root = this.getRoot();
        if (!root.isEmptySlot()) {
            root.postProcess();
        }
    }
}

