/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;

public final class FunctionABS
extends AbstractFunction {
    private static final ValueType[][] ARGUMENT_TYPES = new ValueType[][]{{ValueType.INT}, {ValueType.FLOAT}};

    @Override
    @Nonnull
    public String getName() {
        return "abs";
    }

    @Nonnull
    public Value executeInt(@Nonnull PreprocessorContext context, @Nonnull Value value) {
        return Value.valueOf(Math.abs(value.asLong()));
    }

    @Nonnull
    public Value executeFloat(@Nonnull PreprocessorContext context, @Nonnull Value value) {
        return Value.valueOf(Float.valueOf(Math.abs(value.asFloat().floatValue())));
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARGUMENT_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "numeric absolute value";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.ANY;
    }
}

