/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import hidden.jcp.org.apache.commons.codec.binary.Base64;
import hidden.jcp.org.apache.commons.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.zip.Deflater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FunctionBINFILE
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.STRING}};

    private static boolean hasSplitFlag(@Nonnull String name, @Nonnull Type type) {
        String opts = name.substring(type.name.length());
        return opts.contains("S") || opts.contains("s");
    }

    private static boolean hasDeflateFlag(@Nonnull String name, @Nonnull Type type) {
        String opts = name.substring(type.name.length());
        return opts.contains("D") || opts.contains("d");
    }

    @Nonnull
    private static String convertTo(@Nonnull File file, @Nonnull Type type, boolean deflate, int lineLength, @Nonnull String endOfLine) throws IOException {
        StringBuilder result = new StringBuilder(512);
        byte[] array = FileUtils.readFileToByteArray(file);
        if (deflate) {
            array = FunctionBINFILE.deflate(array);
        }
        boolean addNextLine = false;
        int visibleLineCharsCounter = 0;
        switch (type) {
            case BASE64: {
                String baseEncoded = new Base64(lineLength, endOfLine.getBytes(StandardCharsets.UTF_8), false).encodeAsString(array);
                result.append(baseEncoded.trim());
                break;
            }
            case BYTEARRAY: 
            case UINT8: 
            case INT8: {
                for (byte b : array) {
                    if (result.length() > 0) {
                        result.append(',');
                        ++visibleLineCharsCounter;
                    }
                    if (addNextLine) {
                        addNextLine = false;
                        visibleLineCharsCounter = 0;
                        result.append(endOfLine);
                    }
                    int initialBufferLength = result.length();
                    switch (type) {
                        case BYTEARRAY: {
                            result.append("(byte)0x").append(Integer.toHexString(b & 0xFF).toUpperCase(Locale.ENGLISH));
                            break;
                        }
                        case UINT8: {
                            result.append(Integer.toString(b & 0xFF).toUpperCase(Locale.ENGLISH));
                            break;
                        }
                        case INT8: {
                            result.append(Integer.toString(b).toUpperCase(Locale.ENGLISH));
                            break;
                        }
                        default: {
                            throw new Error("Unexpected type : " + (Object)((Object)type));
                        }
                    }
                    if (lineLength <= 0 || (visibleLineCharsCounter += result.length() - initialBufferLength) < lineLength) continue;
                    addNextLine = true;
                }
                break;
            }
            default: {
                throw new Error("Unexpected type : " + (Object)((Object)type));
            }
        }
        return result.toString();
    }

    @Nonnull
    private static byte[] deflate(@Nonnull byte[] data) throws IOException {
        Deflater deflater = new Deflater(9);
        deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        deflater.finish();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        deflater.end();
        return output;
    }

    @Override
    @Nonnull
    public String getName() {
        return "binfile";
    }

    @Override
    @Nonnull
    public String getReference() {
        StringBuilder buffer = new StringBuilder();
        for (Type t : Type.values()) {
            if (buffer.length() > 0) {
                buffer.append('|');
            }
            buffer.append(t.name);
        }
        buffer.append("[s|d|sd|ds]");
        return "encode binary file as string, allowed types [" + buffer.toString() + "], s - split lines, d - deflater compression";
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }

    @Nonnull
    public Value executeStrStr(@Nonnull PreprocessorContext context, @Nonnull Value strFilePath, @Nonnull Value encodeType) {
        File theFile;
        String filePath = strFilePath.asString();
        String encodeTypeAsString = encodeType.asString();
        Type type = Type.find(encodeTypeAsString);
        if (type == null) {
            throw context.makeException("Unsupported encode type [" + encodeType.asString() + ']', null);
        }
        int lengthOfLine = FunctionBINFILE.hasSplitFlag(encodeTypeAsString, type) ? 80 : -1;
        boolean doDeflate = FunctionBINFILE.hasDeflateFlag(encodeTypeAsString, type);
        try {
            theFile = context.findFileInSources(filePath);
        }
        catch (IOException ex) {
            throw context.makeException("Can't find bin file '" + filePath + '\'', null);
        }
        if (context.isVerbose()) {
            context.logForVerbose("Loading content of bin file '" + theFile + '\'');
        }
        try {
            String endOfLine = System.getProperty("line.separator", "\r\n");
            return Value.valueOf(FunctionBINFILE.convertTo(theFile, type, doDeflate, lengthOfLine, endOfLine));
        }
        catch (Exception ex) {
            throw context.makeException("Unexpected exception", ex);
        }
    }

    private static enum Type {
        BASE64("base64"),
        BYTEARRAY("byte[]"),
        UINT8("uint8[]"),
        INT8("int8[]");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Nullable
        public static Type find(@Nullable String name) {
            Type result = null;
            if (name != null) {
                String normalized = name.toLowerCase(Locale.ENGLISH).trim();
                for (Type t : Type.values()) {
                    if (!normalized.startsWith(t.name)) continue;
                    result = t;
                    break;
                }
            }
            return result;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }
    }
}

