/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;

public final class FunctionDefinedByUser
extends AbstractFunction {
    private final String name;
    private final int argsNumber;
    private final ValueType[][] argTypes;

    public FunctionDefinedByUser(@Nonnull String name, int argsNumber, @Nonnull PreprocessorContext context) {
        Assertions.assertNotNull("Name is null", name);
        Assertions.assertNotNull("Context is null", context);
        if (argsNumber < 0) {
            throw context.makeException("Unexpected argument number [" + argsNumber + ']', null);
        }
        this.name = name;
        this.argsNumber = argsNumber;
        ValueType[] types = new ValueType[argsNumber];
        for (int li = 0; li < argsNumber; ++li) {
            types[li] = ValueType.ANY;
        }
        this.argTypes = new ValueType[][]{types};
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public int getArity() {
        return this.argsNumber;
    }

    @Nonnull
    public Value execute(@Nonnull PreprocessorContext context, @Nonnull @MustNotContainNull Value[] values) {
        return Assertions.assertNotNull("Preprocessor extension must not be null", context.getPreprocessorExtension()).processUserFunction(this.name, values);
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return this.argTypes;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "user defined function";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.ANY;
    }
}

