/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.annotation.Nonnull;

public class FunctionEVALFILE
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "evalfile";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "preprocess file and get result as string";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }

    @Nonnull
    private PreprocessorContext prepareContext(@Nonnull PreprocessorContext base) {
        PreprocessorContext result = new PreprocessorContext(base);
        result.setDryRun(true);
        result.setKeepLines(false);
        result.setClearTarget(false);
        result.setKeepComments(false);
        result.setCareForLastEol(true);
        return result;
    }

    @Nonnull
    public Value executeStr(@Nonnull PreprocessorContext context, @Nonnull Value strFilePath) {
        File theFile;
        String filePath = strFilePath.asString();
        try {
            theFile = context.findFileInSources(filePath);
        }
        catch (IOException ex) {
            throw context.makeException("Can't get get source file '" + filePath + '\'', null);
        }
        if (context.isVerbose()) {
            context.logForVerbose("Eval file '" + theFile + '\'');
        }
        try {
            FileInfoContainer fileContainer = new FileInfoContainer(theFile, theFile.getName(), false);
            PreprocessingState state = fileContainer.preprocessFile(null, this.prepareContext(context));
            StringWriter strWriter = new StringWriter(1024);
            state.writePrinterBuffers(strWriter);
            IOUtils.closeQuietly(strWriter);
            return Value.valueOf(strWriter.toString());
        }
        catch (Exception ex) {
            throw context.makeException("Unexpected exception", ex);
        }
    }
}

