/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;

public final class FunctionIS
extends AbstractFunction {
    private static final ValueType[][] SIGNATURES = new ValueType[][]{{ValueType.STRING, ValueType.ANY}};

    @Override
    @Nonnull
    public String getName() {
        return "is";
    }

    @Nonnull
    public Value executeStrAny(@Nonnull PreprocessorContext context, @Nonnull Value varName, @Nonnull Value value) {
        Value currentValue = context.findVariableForName(varName.asString(), false);
        Value result = Value.BOOLEAN_FALSE;
        if (currentValue != null) {
            result = value.toString().compareTo(currentValue.toString()) == 0 ? Value.BOOLEAN_TRUE : Value.BOOLEAN_FALSE;
        }
        return result;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return SIGNATURES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "check that string is string form of value";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.BOOLEAN;
    }
}

