/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;

public final class FunctionISSUBSTR
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "issubstr";
    }

    @Nonnull
    public Value executeStrStr(@Nonnull PreprocessorContext context, @Nonnull Value subStrValue, @Nonnull Value strValue) {
        String str = strValue.asString().toLowerCase();
        String subStr = subStrValue.asString().toLowerCase();
        return Value.valueOf(str.contains(subStr));
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "check that string contains substring (case insensitive)";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.BOOLEAN;
    }
}

