/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;

public final class FunctionROUND
extends AbstractFunction {
    private static final ValueType[][] SIGNATURES = new ValueType[][]{{ValueType.FLOAT}, {ValueType.INT}};

    @Override
    @Nonnull
    public String getName() {
        return "round";
    }

    @Nonnull
    public Value executeInt(@Nonnull PreprocessorContext context, @Nonnull Value value) {
        return value;
    }

    @Nonnull
    public Value executeFloat(@Nonnull PreprocessorContext context, @Nonnull Value value) {
        return Value.valueOf(Long.valueOf(Math.round(value.asFloat().floatValue())));
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return SIGNATURES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "round float value to nearest integer";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.INT;
    }
}

