/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractStrConverter;
import hidden.jcp.org.apache.commons.text.StringEscapeUtils;
import javax.annotation.Nonnull;

public final class FunctionSTR2WEB
extends AbstractStrConverter {
    @Override
    @Nonnull
    public String getName() {
        return "str2web";
    }

    @Override
    @Nonnull
    public Value executeStr(@Nonnull PreprocessorContext context, @Nonnull Value value) {
        String escaped = StringEscapeUtils.escapeHtml3(value.asString());
        StringBuilder result = new StringBuilder(escaped.length() * 2);
        for (int i = 0; i < escaped.length(); ++i) {
            char ch = escaped.charAt(i);
            if (ch < '\u0080') {
                result.append(ch);
                continue;
            }
            result.append("&#").append(Character.codePointAt(escaped, i)).append(';');
        }
        return Value.valueOf(result.toString());
    }

    @Override
    @Nonnull
    public String getReference() {
        return "escape string for HTML3";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

