/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.xml.AbstractXMLFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import hidden.jcp.org.w3c.dom.Element;
import hidden.jcp.org.w3c.dom.NodeList;
import javax.annotation.Nonnull;

public final class FunctionXML_LIST
extends AbstractXMLFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "xml_list";
    }

    @Nonnull
    public Value executeStrStr(@Nonnull PreprocessorContext context, @Nonnull Value elementId, @Nonnull Value elementTag) {
        String tagName = elementTag.asString();
        Element element = this.getCachedElement(context, elementId.asString());
        String listId = FunctionXML_LIST.makeElementListId(element, tagName);
        NodeContainer container = (NodeContainer)context.getSharedResource(listId);
        if (container == null) {
            NodeList list = element.getElementsByTagName(tagName);
            container = new NodeContainer(UID_COUNTER.getAndIncrement(), list);
            context.setSharedResource(listId, container);
        }
        return Value.valueOf(listId);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "get list of elements by tag name";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

