/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.xml.AbstractXMLFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import hidden.jcp.javax.xml.xpath.XPathConstants;
import hidden.jcp.javax.xml.xpath.XPathExpression;
import hidden.jcp.javax.xml.xpath.XPathExpressionException;
import hidden.jcp.org.w3c.dom.Document;
import hidden.jcp.org.w3c.dom.Element;
import javax.annotation.Nonnull;

public final class FunctionXML_XELEMENT
extends AbstractXMLFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "xml_xelement";
    }

    @Nonnull
    public Value executeStrStr(@Nonnull PreprocessorContext context, @Nonnull Value documentId, @Nonnull Value xPath) {
        String documentIdStr = documentId.asString();
        String pathStr = xPath.asString();
        String xpathElementId = FunctionXML_XELEMENT.makeXPathElementId(documentIdStr, pathStr);
        Document document = this.getCachedDocument(context, documentIdStr);
        Element elem = this.findCachedElement(context, xpathElementId);
        if (elem == null) {
            try {
                XPathExpression expression = FunctionXML_XELEMENT.prepareXPathExpression(pathStr);
                elem = (Element)expression.evaluate(document, XPathConstants.NODE);
                if (elem == null) {
                    throw context.makeException("Can't find element for xpath [" + pathStr + ']', null);
                }
            }
            catch (XPathExpressionException ex) {
                throw context.makeException("Error during XPath compilation [" + pathStr + ']', ex);
            }
            catch (ClassCastException ex) {
                throw context.makeException("Can't get element for XPath [" + pathStr + ']', ex);
            }
            NodeContainer container = new NodeContainer(UID_COUNTER.getAndIncrement(), elem);
            context.setSharedResource(xpathElementId, container);
        }
        return Value.valueOf(xpathElementId);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "find single element with XPath, error if not found";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

