/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.operators;

import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.operators.OperatorADD;
import com.igormaznitsa.jcp.expression.operators.OperatorAND;
import com.igormaznitsa.jcp.expression.operators.OperatorDIV;
import com.igormaznitsa.jcp.expression.operators.OperatorEQU;
import com.igormaznitsa.jcp.expression.operators.OperatorGREAT;
import com.igormaznitsa.jcp.expression.operators.OperatorGREATEQU;
import com.igormaznitsa.jcp.expression.operators.OperatorLESS;
import com.igormaznitsa.jcp.expression.operators.OperatorLESSEQU;
import com.igormaznitsa.jcp.expression.operators.OperatorMOD;
import com.igormaznitsa.jcp.expression.operators.OperatorMUL;
import com.igormaznitsa.jcp.expression.operators.OperatorNOT;
import com.igormaznitsa.jcp.expression.operators.OperatorNOTEQU;
import com.igormaznitsa.jcp.expression.operators.OperatorOR;
import com.igormaznitsa.jcp.expression.operators.OperatorSUB;
import com.igormaznitsa.jcp.expression.operators.OperatorXOR;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractOperator
implements ExpressionItem {
    public static final String EXECUTION_PREFIX = "execute";
    private static AbstractOperator[] allOperators;

    @Nonnull
    @MustNotContainNull
    public static AbstractOperator[] getAllOperators() {
        if (allOperators == null) {
            allOperators = new AbstractOperator[]{new OperatorEQU(), new OperatorGREAT(), new OperatorGREATEQU(), new OperatorLESS(), new OperatorLESSEQU(), new OperatorNOTEQU(), new OperatorADD(), new OperatorSUB(), new OperatorMUL(), new OperatorDIV(), new OperatorMOD(), new OperatorNOT(), new OperatorAND(), new OperatorOR(), new OperatorXOR()};
        }
        return allOperators;
    }

    @Nullable
    public static <E extends AbstractOperator> E findForClass(@Nonnull Class<E> operatorClass) {
        for (AbstractOperator operator : AbstractOperator.getAllOperators()) {
            if (operator.getClass() != operatorClass) continue;
            return (E)((AbstractOperator)operatorClass.cast(operator));
        }
        return null;
    }

    @Override
    @Nonnull
    public ExpressionItemType getExpressionItemType() {
        return ExpressionItemType.OPERATOR;
    }

    public abstract int getArity();

    @Nonnull
    public abstract String getKeyword();

    @Nonnull
    public abstract String getReference();

    @Nonnull
    public String toString() {
        return "OPERATOR: " + this.getKeyword();
    }
}

