/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.operators;

import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import javax.annotation.Nonnull;

public final class OperatorEQU
extends AbstractOperator {
    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "equal to";
    }

    @Override
    @Nonnull
    public String getKeyword() {
        return "==";
    }

    @Nonnull
    public Value executeIntInt(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(arg1.asLong().longValue() == arg2.asLong().longValue());
    }

    @Nonnull
    public Value executeFloatInt(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(Float.compare(arg1.asFloat().floatValue(), arg2.asLong().floatValue()) == 0);
    }

    @Nonnull
    public Value executeIntFloat(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(Float.compare(arg1.asLong().floatValue(), arg2.asFloat().floatValue()) == 0);
    }

    @Nonnull
    public Value executeFloatFloat(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(Float.compare(arg1.asFloat().floatValue(), arg2.asFloat().floatValue()) == 0);
    }

    @Nonnull
    public Value executeStrStr(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(arg1.asString().equals(arg2.asString()));
    }

    @Nonnull
    public Value executeBoolBool(@Nonnull Value arg1, @Nonnull Value arg2) {
        return Value.valueOf(arg1.asBoolean().booleanValue() == arg2.asBoolean().booleanValue());
    }

    @Override
    @Nonnull
    public ExpressionItemPriority getExpressionItemPriority() {
        return ExpressionItemPriority.COMPARISON;
    }
}

