/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.gradle;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.execution.commandline.TaskConfigurationException;

public class JcpPreprocessExtension {
    public static final String ID = "preprocessSettings";
    private List<String> sources = null;
    private String eol = null;
    private boolean keepAttributes = false;
    private File target = null;
    private String sourceEncoding = StandardCharsets.UTF_8.name();
    private String targetEncoding = StandardCharsets.UTF_8.name();
    private boolean ignoreMissingSources = false;
    private List<String> excludeExtensions = null;
    private List<String> extensions = null;
    private boolean unknownVarAsFalse = false;
    private boolean dryRun = false;
    private boolean verbose = false;
    private boolean clearTarget = false;
    private File baseDir = null;
    private boolean careForLastEol = false;
    private boolean keepComments = true;
    private Map<String, String> vars = new HashMap<String, String>();
    private List<String> excludeFolders = new ArrayList<String>();
    private List<String> configFiles = new ArrayList<String>();
    private boolean keepLines = true;
    private boolean allowWhitespaces = false;
    private boolean preserveIndents = false;
    private boolean skip = false;
    private boolean dontOverwriteSameContent = false;

    public JcpPreprocessExtension(Project project) {
        if (this.baseDir == null) {
            this.baseDir = project.getProjectDir();
        }
    }

    private void assertCharSet(@Nullable String name) {
        if (name == null || !Charset.isSupported(name)) {
            throw new TaskConfigurationException("preprocess", "Unsupported charset: " + name, null);
        }
    }

    public void validate(Project project) {
        if (this.baseDir == null) {
            throw new TaskConfigurationException("preprocess", "Basedir must be defined", null);
        }
        if (!this.baseDir.isDirectory()) {
            throw new TaskConfigurationException("preprocess", "Basedir doesn't exist: " + this.baseDir, null);
        }
        this.assertCharSet(this.sourceEncoding);
        this.assertCharSet(this.targetEncoding);
        if (this.sources == null) {
            throw new TaskConfigurationException("preprocess", "Source folders are not deined in 'sources'", null);
        }
        if (this.sources.isEmpty()) {
            throw new TaskConfigurationException("preprocess", "Source folder list is empty", null);
        }
        if (this.target == null) {
            throw new TaskConfigurationException("preprocess", "Target folder is not deined in 'target'", null);
        }
    }

    public List<String> getSources() {
        return this.sources;
    }

    public String getEol() {
        return this.eol;
    }

    public boolean isKeepAttributes() {
        return this.keepAttributes;
    }

    public File getTarget() {
        return this.target;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public boolean isIgnoreMissingSources() {
        return this.ignoreMissingSources;
    }

    public List<String> getExcludeExtensions() {
        return this.excludeExtensions;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean isUnknownVarAsFalse() {
        return this.unknownVarAsFalse;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isClearTarget() {
        return this.clearTarget;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isCareForLastEol() {
        return this.careForLastEol;
    }

    public boolean isKeepComments() {
        return this.keepComments;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public List<String> getExcludeFolders() {
        return this.excludeFolders;
    }

    public List<String> getConfigFiles() {
        return this.configFiles;
    }

    public boolean isKeepLines() {
        return this.keepLines;
    }

    public boolean isAllowWhitespaces() {
        return this.allowWhitespaces;
    }

    public boolean isPreserveIndents() {
        return this.preserveIndents;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isDontOverwriteSameContent() {
        return this.dontOverwriteSameContent;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public void setKeepAttributes(boolean keepAttributes) {
        this.keepAttributes = keepAttributes;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setTargetEncoding(String targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    public void setIgnoreMissingSources(boolean ignoreMissingSources) {
        this.ignoreMissingSources = ignoreMissingSources;
    }

    public void setExcludeExtensions(List<String> excludeExtensions) {
        this.excludeExtensions = excludeExtensions;
    }

    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public void setUnknownVarAsFalse(boolean unknownVarAsFalse) {
        this.unknownVarAsFalse = unknownVarAsFalse;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setClearTarget(boolean clearTarget) {
        this.clearTarget = clearTarget;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCareForLastEol(boolean careForLastEol) {
        this.careForLastEol = careForLastEol;
    }

    public void setKeepComments(boolean keepComments) {
        this.keepComments = keepComments;
    }

    public void setVars(Map<String, String> vars) {
        this.vars = vars;
    }

    public void setExcludeFolders(List<String> excludeFolders) {
        this.excludeFolders = excludeFolders;
    }

    public void setConfigFiles(List<String> configFiles) {
        this.configFiles = configFiles;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public void setAllowWhitespaces(boolean allowWhitespaces) {
        this.allowWhitespaces = allowWhitespaces;
    }

    public void setPreserveIndents(boolean preserveIndents) {
        this.preserveIndents = preserveIndents;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setDontOverwriteSameContent(boolean dontOverwriteSameContent) {
        this.dontOverwriteSameContent = dontOverwriteSameContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JcpPreprocessExtension)) {
            return false;
        }
        JcpPreprocessExtension other = (JcpPreprocessExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$sources = this.getSources();
        List<String> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        String this$eol = this.getEol();
        String other$eol = other.getEol();
        if (this$eol == null ? other$eol != null : !this$eol.equals(other$eol)) {
            return false;
        }
        if (this.isKeepAttributes() != other.isKeepAttributes()) {
            return false;
        }
        File this$target = this.getTarget();
        File other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        String this$sourceEncoding = this.getSourceEncoding();
        String other$sourceEncoding = other.getSourceEncoding();
        if (this$sourceEncoding == null ? other$sourceEncoding != null : !this$sourceEncoding.equals(other$sourceEncoding)) {
            return false;
        }
        String this$targetEncoding = this.getTargetEncoding();
        String other$targetEncoding = other.getTargetEncoding();
        if (this$targetEncoding == null ? other$targetEncoding != null : !this$targetEncoding.equals(other$targetEncoding)) {
            return false;
        }
        if (this.isIgnoreMissingSources() != other.isIgnoreMissingSources()) {
            return false;
        }
        List<String> this$excludeExtensions = this.getExcludeExtensions();
        List<String> other$excludeExtensions = other.getExcludeExtensions();
        if (this$excludeExtensions == null ? other$excludeExtensions != null : !((Object)this$excludeExtensions).equals(other$excludeExtensions)) {
            return false;
        }
        List<String> this$extensions = this.getExtensions();
        List<String> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        if (this.isUnknownVarAsFalse() != other.isUnknownVarAsFalse()) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isVerbose() != other.isVerbose()) {
            return false;
        }
        if (this.isClearTarget() != other.isClearTarget()) {
            return false;
        }
        File this$baseDir = this.getBaseDir();
        File other$baseDir = other.getBaseDir();
        if (this$baseDir == null ? other$baseDir != null : !((Object)this$baseDir).equals(other$baseDir)) {
            return false;
        }
        if (this.isCareForLastEol() != other.isCareForLastEol()) {
            return false;
        }
        if (this.isKeepComments() != other.isKeepComments()) {
            return false;
        }
        Map<String, String> this$vars = this.getVars();
        Map<String, String> other$vars = other.getVars();
        if (this$vars == null ? other$vars != null : !((Object)this$vars).equals(other$vars)) {
            return false;
        }
        List<String> this$excludeFolders = this.getExcludeFolders();
        List<String> other$excludeFolders = other.getExcludeFolders();
        if (this$excludeFolders == null ? other$excludeFolders != null : !((Object)this$excludeFolders).equals(other$excludeFolders)) {
            return false;
        }
        List<String> this$configFiles = this.getConfigFiles();
        List<String> other$configFiles = other.getConfigFiles();
        if (this$configFiles == null ? other$configFiles != null : !((Object)this$configFiles).equals(other$configFiles)) {
            return false;
        }
        if (this.isKeepLines() != other.isKeepLines()) {
            return false;
        }
        if (this.isAllowWhitespaces() != other.isAllowWhitespaces()) {
            return false;
        }
        if (this.isPreserveIndents() != other.isPreserveIndents()) {
            return false;
        }
        if (this.isSkip() != other.isSkip()) {
            return false;
        }
        return this.isDontOverwriteSameContent() == other.isDontOverwriteSameContent();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JcpPreprocessExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        String $eol = this.getEol();
        result = result * 59 + ($eol == null ? 43 : $eol.hashCode());
        result = result * 59 + (this.isKeepAttributes() ? 79 : 97);
        File $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        String $sourceEncoding = this.getSourceEncoding();
        result = result * 59 + ($sourceEncoding == null ? 43 : $sourceEncoding.hashCode());
        String $targetEncoding = this.getTargetEncoding();
        result = result * 59 + ($targetEncoding == null ? 43 : $targetEncoding.hashCode());
        result = result * 59 + (this.isIgnoreMissingSources() ? 79 : 97);
        List<String> $excludeExtensions = this.getExcludeExtensions();
        result = result * 59 + ($excludeExtensions == null ? 43 : ((Object)$excludeExtensions).hashCode());
        List<String> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        result = result * 59 + (this.isUnknownVarAsFalse() ? 79 : 97);
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isVerbose() ? 79 : 97);
        result = result * 59 + (this.isClearTarget() ? 79 : 97);
        File $baseDir = this.getBaseDir();
        result = result * 59 + ($baseDir == null ? 43 : ((Object)$baseDir).hashCode());
        result = result * 59 + (this.isCareForLastEol() ? 79 : 97);
        result = result * 59 + (this.isKeepComments() ? 79 : 97);
        Map<String, String> $vars = this.getVars();
        result = result * 59 + ($vars == null ? 43 : ((Object)$vars).hashCode());
        List<String> $excludeFolders = this.getExcludeFolders();
        result = result * 59 + ($excludeFolders == null ? 43 : ((Object)$excludeFolders).hashCode());
        List<String> $configFiles = this.getConfigFiles();
        result = result * 59 + ($configFiles == null ? 43 : ((Object)$configFiles).hashCode());
        result = result * 59 + (this.isKeepLines() ? 79 : 97);
        result = result * 59 + (this.isAllowWhitespaces() ? 79 : 97);
        result = result * 59 + (this.isPreserveIndents() ? 79 : 97);
        result = result * 59 + (this.isSkip() ? 79 : 97);
        result = result * 59 + (this.isDontOverwriteSameContent() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "JcpPreprocessExtension(sources=" + this.getSources() + ", eol=" + this.getEol() + ", keepAttributes=" + this.isKeepAttributes() + ", target=" + this.getTarget() + ", sourceEncoding=" + this.getSourceEncoding() + ", targetEncoding=" + this.getTargetEncoding() + ", ignoreMissingSources=" + this.isIgnoreMissingSources() + ", excludeExtensions=" + this.getExcludeExtensions() + ", extensions=" + this.getExtensions() + ", unknownVarAsFalse=" + this.isUnknownVarAsFalse() + ", dryRun=" + this.isDryRun() + ", verbose=" + this.isVerbose() + ", clearTarget=" + this.isClearTarget() + ", baseDir=" + this.getBaseDir() + ", careForLastEol=" + this.isCareForLastEol() + ", keepComments=" + this.isKeepComments() + ", vars=" + this.getVars() + ", excludeFolders=" + this.getExcludeFolders() + ", configFiles=" + this.getConfigFiles() + ", keepLines=" + this.isKeepLines() + ", allowWhitespaces=" + this.isAllowWhitespaces() + ", preserveIndents=" + this.isPreserveIndents() + ", skip=" + this.isSkip() + ", dontOverwriteSameContent=" + this.isDontOverwriteSameContent() + ")";
    }
}

