/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.gradle;

import com.igormaznitsa.jcp.JcpPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.gradle.JcpPreprocessExtension;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;

public class JcpPreprocessTask
extends DefaultTask {
    public static final String ID = "preprocess";

    @TaskAction
    public void preprocessTask() throws IOException {
        final Logger logger = this.getProject().getLogger();
        JcpPreprocessExtension preprocessExtension = (JcpPreprocessExtension)this.getProject().getExtensions().findByType(JcpPreprocessExtension.class);
        if (preprocessExtension == null) {
            preprocessExtension = new JcpPreprocessExtension(this.getProject());
        }
        preprocessExtension.validate(this.getProject());
        File baseDir = preprocessExtension.getBaseDir();
        PreprocessorContext preprocessorContext = new PreprocessorContext(baseDir);
        preprocessorContext.setPreprocessorLogger(new PreprocessorLogger(){

            @Override
            public void error(@Nullable String message) {
                logger.error(message);
            }

            @Override
            public void info(@Nullable String message) {
                logger.info(message);
            }

            @Override
            public void debug(@Nullable String message) {
                logger.debug(message);
            }

            @Override
            public void warning(@Nullable String message) {
                logger.warn(message);
            }
        });
        if (preprocessExtension.getConfigFiles() != null) {
            for (String string : preprocessExtension.getConfigFiles()) {
                File cfgFile = new File(baseDir, string);
                if (cfgFile.isFile()) {
                    logger.debug("Registering config file: " + cfgFile);
                    preprocessorContext.registerConfigFile(cfgFile);
                    continue;
                }
                throw new TaskExecutionException((Task)this, (Throwable)new IOException("Can't find config file: " + FilenameUtils.normalize(cfgFile.getAbsolutePath())));
            }
        }
        preprocessorContext.setTarget(preprocessExtension.getTarget());
        preprocessorContext.setSources(preprocessExtension.getSources());
        if (preprocessExtension.getEol() == null) {
            logger.debug("Using default EOL");
        } else {
            preprocessorContext.setEol(preprocessExtension.getEol());
        }
        if (preprocessExtension.getExcludeFolders() != null) {
            preprocessorContext.setExcludeFolders(preprocessExtension.getExcludeFolders());
        }
        preprocessorContext.setDontOverwriteSameContent(preprocessExtension.isDontOverwriteSameContent());
        preprocessorContext.setClearTarget(preprocessExtension.isClearTarget());
        preprocessorContext.setCareForLastEol(preprocessExtension.isCareForLastEol());
        preprocessorContext.setKeepComments(preprocessExtension.isKeepComments());
        preprocessorContext.setDryRun(preprocessExtension.isDryRun());
        preprocessorContext.setKeepAttributes(preprocessExtension.isKeepAttributes());
        preprocessorContext.setKeepLines(preprocessExtension.isKeepLines());
        preprocessorContext.setAllowWhitespaces(preprocessExtension.isAllowWhitespaces());
        if (preprocessExtension.getExcludeExtensions() != null) {
            logger.debug("Excluding extensions: " + preprocessExtension.getExcludeExtensions());
            preprocessorContext.setExcludeExtensions(preprocessExtension.getExcludeExtensions());
        }
        if (preprocessExtension.getExtensions() != null) {
            logger.debug("Extensions: " + preprocessExtension.getExtensions());
            preprocessorContext.setExtensions(preprocessExtension.getExtensions());
        }
        if (preprocessExtension.getVars() != null) {
            for (Map.Entry entry : preprocessExtension.getVars().entrySet()) {
                logger.debug(String.format("Registering global variable: %s=%s", entry.getKey(), entry.getValue()));
                preprocessorContext.setGlobalVariable((String)entry.getKey(), Value.recognizeRawString((String)entry.getValue()));
            }
        }
        preprocessorContext.setPreserveIndents(preprocessExtension.isPreserveIndents());
        preprocessorContext.setSourceEncoding(Charset.forName(preprocessExtension.getSourceEncoding()));
        preprocessorContext.setTargetEncoding(Charset.forName(preprocessExtension.getTargetEncoding()));
        preprocessorContext.setUnknownVariableAsFalse(preprocessExtension.isUnknownVarAsFalse());
        preprocessorContext.setVerbose(preprocessExtension.isVerbose());
        JcpPreprocessor preprocessor = new JcpPreprocessor(preprocessorContext);
        logger.debug("Start preprocessing...");
        try {
            preprocessor.execute();
        }
        catch (PreprocessorException preprocessorException) {
            throw new TaskExecutionException((Task)this, (Throwable)preprocessorException);
        }
    }
}

