/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.logger;

import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import javax.annotation.Nullable;

public final class SystemOutLogger
implements PreprocessorLogger {
    public static final String PROPERTY_DEBUG_FLAG = "jcp.log.debug";
    private static final boolean FLAG_DEBUG_LEVEL = Boolean.parseBoolean(System.getProperty("jcp.log.debug"));

    public int hashCode() {
        return System.out.hashCode();
    }

    public boolean equals(@Nullable Object value) {
        return value instanceof SystemOutLogger;
    }

    @Override
    public void error(@Nullable String text) {
        if (text != null) {
            String out = "[JCP.ERR] " + text;
            System.err.println(out);
        }
    }

    @Override
    public void info(@Nullable String text) {
        if (text != null) {
            String out = "[JCP.INFO] " + text;
            System.out.println(out);
        }
    }

    @Override
    public void warning(@Nullable String text) {
        if (text != null) {
            String out = "[JCP.WARN] " + text;
            System.out.println(out);
        }
    }

    @Override
    public void debug(@Nullable String text) {
        if (FLAG_DEBUG_LEVEL && text != null) {
            String out = "[JCP.DEBUG] " + text;
            System.out.println(out);
        }
    }
}

