/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.templates;

import com.igormaznitsa.meta.annotation.Warning;
import com.igormaznitsa.meta.common.exceptions.AlreadyDisposedError;
import com.igormaznitsa.meta.common.exceptions.MetaErrorListeners;
import com.igormaznitsa.meta.common.interfaces.Disposable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class DisposableTemplate
implements Disposable,
Serializable {
    private static final AtomicLong DISPOSABLE_OBJECT_COUNTER = new AtomicLong();
    private static final long serialVersionUID = 789238003359873015L;
    private final AtomicBoolean disposedFlag = new AtomicBoolean();

    @Warning(value="Must be called in successors")
    public DisposableTemplate() {
        DISPOSABLE_OBJECT_COUNTER.incrementAndGet();
    }

    public static long getNonDisposedObjectCounter() {
        return DISPOSABLE_OBJECT_COUNTER.get();
    }

    protected void assertNotDisposed() {
        if (this.disposedFlag.get()) {
            AlreadyDisposedError error = new AlreadyDisposedError("Object already disposed");
            MetaErrorListeners.fireError("Detected call to disposed object", (Throwable)((Object)error));
            throw error;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposedFlag.get();
    }

    @Override
    public final void dispose() {
        if (this.disposedFlag.compareAndSet(false, true)) {
            DISPOSABLE_OBJECT_COUNTER.decrementAndGet();
            this.doDispose();
        } else {
            this.assertNotDisposed();
        }
    }

    protected abstract void doDispose();
}

