/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.MayContainNull;
import com.igormaznitsa.meta.annotation.Weight;
import java.lang.reflect.Array;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final boolean[] EMPTY_BOOL_ARRAY = new boolean[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];

    private ArrayUtils() {
    }

    @SafeVarargs
    @Nonnull
    @MayContainNull
    @Weight(value=Weight.Unit.NORMAL)
    public static <T> T[] joinArrays(T[] ... arrays) {
        int commonLength = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            commonLength += array.length;
        }
        Object[] result = (Object[])Array.newInstance(arrays.getClass().getComponentType().getComponentType(), commonLength);
        int position = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, position, array.length);
            position += array.length;
        }
        return result;
    }
}

