/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.Constraint;
import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Weight(value=Weight.Unit.LIGHT)
public final class GetUtils {
    private GetUtils() {
    }

    @Nonnull
    public static <T> T ensureNonNull(@Nullable T value, @Nonnull T defaultValue) {
        return value == null ? Assertions.assertNotNull(defaultValue) : value;
    }

    @Nonnull
    public static <T> T ensureNonNull(@Nonnull T value) {
        return Assertions.assertNotNull(value);
    }

    @SafeVarargs
    @Nonnull
    public static <T> T findFirstNonNull(T ... objects) {
        for (T obj : GetUtils.ensureNonNull(objects)) {
            if (obj == null) continue;
            return obj;
        }
        throw Assertions.fail("Can't find non-null item in array");
    }

    @Nonnull
    public static String ensureNonNullAndNonEmpty(@Nullable String value, @Nonnull @Constraint(value="notEmpty(X)") String dflt) {
        String result = value;
        if (result == null || result.isEmpty()) {
            Assertions.assertFalse("Default value must not be empty", Assertions.assertNotNull("Default value must not be null", dflt).isEmpty());
            result = dflt;
        }
        return result;
    }

    @Nonnull
    public static String ensureNonNullStr(@Nullable String value) {
        return value == null ? "" : value;
    }
}

