/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.common.exceptions.MetaErrorListeners;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class IOUtils {
    private IOUtils() {
    }

    @Nonnull
    @Weight(value=Weight.Unit.VARIABLE)
    public static byte[] packData(@Nonnull byte[] data) {
        Deflater compressor = new Deflater(9);
        compressor.setInput(Assertions.assertNotNull(data));
        compressor.finish();
        ByteArrayOutputStream resultData = new ByteArrayOutputStream(data.length + 100);
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            resultData.write(buffer, 0, compressor.deflate(buffer));
        }
        return resultData.toByteArray();
    }

    @Nonnull
    @Weight(value=Weight.Unit.VARIABLE)
    public static byte[] unpackData(@Nonnull byte[] data) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(Assertions.assertNotNull(data));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(data.length * 2);
        byte[] buffer = new byte[1024];
        try {
            while (!decompressor.finished()) {
                outStream.write(buffer, 0, decompressor.inflate(buffer));
            }
            return outStream.toByteArray();
        }
        catch (DataFormatException ex) {
            MetaErrorListeners.fireError("Can't unpack data for wrong format", ex);
            throw new IllegalArgumentException("Wrong formatted data", ex);
        }
    }

    @Nullable
    @Weight(value=Weight.Unit.LIGHT)
    public static Closeable closeQuietly(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                MetaErrorListeners.fireError("Exception in closeQuietly", ex);
            }
        }
        return closeable;
    }
}

