/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp;

import com.igormaznitsa.jcp.JcpPreprocessor;
import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.JCPSpecialVariableProcessor;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public final class InfoHelper {
    public static final String DELIMITER = "-------------------------------------------------";
    public static final String SHORT_DELIMITER = "----------------------";

    private InfoHelper() {
    }

    public static String getVersion() {
        return "v7.0.5";
    }

    public static String getCopyright() {
        return "Copyright (C) 2002-2021 Igor A. Maznitsa (https://www.igormaznitsa.com)";
    }

    public static String getSite() {
        return "Project page: https://github.com/raydac/java-comment-preprocessor";
    }

    public static String getProductName() {
        return "Java Comment Preprocessor";
    }

    public static List<String> makeTextForHelpInfo() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(JcpPreprocessor.class.getCanonicalName() + " [@cfgFile] [cliCommands]");
        result.add("");
        result.add("Command line");
        result.add(SHORT_DELIMITER);
        result.add("allowed '/','-' and '--' prefixes, '--' doesn't support multiple commands at once");
        result.add(InfoHelper.makeColumns("@cfgFile", "file contains global definition list", 14));
        result.addAll(JcpPreprocessor.getCommandLineHandlers().stream().map(InfoHelper::makeCommandLineKeyReference).collect(Collectors.toList()));
        result.add(DELIMITER);
        result.add("Directives");
        result.add(SHORT_DELIMITER);
        for (AbstractDirectiveHandler abstractDirectiveHandler : AbstractDirectiveHandler.getAllDirectives()) {
            result.add(InfoHelper.makeDirectiveReference(abstractDirectiveHandler));
        }
        result.add(DELIMITER);
        result.add("Special directives");
        result.add(SHORT_DELIMITER);
        result.add(InfoHelper.makeSpecialDirectiveReference("//$", "uncomment and process all following macroses"));
        result.add(InfoHelper.makeSpecialDirectiveReference("//$$", "like //$ but macroses ignored"));
        result.add(InfoHelper.makeSpecialDirectiveReference("/*-*/", "truncate line"));
        result.add("Operators");
        result.add(SHORT_DELIMITER);
        for (AbstractOperator abstractOperator : AbstractOperator.getAllOperators()) {
            result.add(InfoHelper.makeOperatorReference(abstractOperator));
        }
        result.add(DELIMITER);
        result.add("Functions");
        result.add(SHORT_DELIMITER);
        for (AbstractFunction abstractFunction : AbstractFunction.getAllFunctions()) {
            result.add(InfoHelper.makeFunctionReference(abstractFunction));
        }
        result.add(DELIMITER);
        result.add("Allowed types");
        result.add(SHORT_DELIMITER);
        result.add(" BOOL: true,false");
        result.add("  INT: 2374,0x56FE (signed 64 bit)");
        result.add("  STR: \"Hello World!\" (or $Hello World!$ if in CLI)");
        result.add("FLOAT: 0.745 (signed 32 bit)");
        result.add(DELIMITER);
        result.add("Special variables");
        result.add(SHORT_DELIMITER);
        result.addAll(JCPSpecialVariableProcessor.getReference().stream().map(InfoHelper::makeSpecialVariableReference).collect(Collectors.toList()));
        return result;
    }

    private static String makeSpecialVariableReference(JCPSpecialVariableProcessor.NameReferencePair p) {
        String name = p.getName();
        String ref = p.getReference();
        return InfoHelper.makeColumns(name, ref, 24);
    }

    private static String makeCommandLineKeyReference(CommandLineHandler handler) {
        String key = handler.getKeyName();
        String descr = handler.getDescription();
        return InfoHelper.makeColumns(key, descr, 14);
    }

    private static String makeDirectiveReference(AbstractDirectiveHandler directive) {
        StringBuilder activityPasses = new StringBuilder();
        int i = 0;
        if (directive.isGlobalPhaseAllowed()) {
            ++i;
            activityPasses.append("1st");
        }
        if (directive.isPreprocessingPhaseAllowed()) {
            if (i > 0) {
                activityPasses.append(',');
            }
            activityPasses.append("2th");
            ++i;
        }
        activityPasses.append(i > 1 ? "passes" : " pass");
        String directiveName = directive.getFullName();
        String descr = (directive.isDeprecated() ? "{DEPRECATED} " : "") + directive.getReference() + " (" + activityPasses.toString() + ')';
        return InfoHelper.makeColumns(directiveName, descr, 16);
    }

    private static String makeSpecialDirectiveReference(String name, String reference) {
        return InfoHelper.makeColumns(name, reference, 14);
    }

    private static String makeOperatorReference(AbstractOperator operator) {
        String operatorName = operator.getKeyword();
        String descr = operator.getReference();
        return InfoHelper.makeColumns(operatorName, descr, 14);
    }

    private static String makeFunctionReference(AbstractFunction func) {
        String funcName = func.getName();
        String descr = func.getReference();
        StringBuilder variants = new StringBuilder("  [");
        String result = func.getResultType().getSignature().toUpperCase(Locale.ENGLISH);
        int variantIndex = 0;
        for (ValueType[] signature : func.getAllowedArgumentTypes()) {
            if (variantIndex > 0) {
                variants.append(" | ");
            }
            variants.append(result).append(' ').append(funcName).append(" (");
            for (int i = 0; i < signature.length; ++i) {
                if (i > 0) {
                    variants.append(',');
                }
                variants.append(signature[i].getSignature().toUpperCase(Locale.ENGLISH));
            }
            variants.append(')');
            ++variantIndex;
        }
        variants.append(']');
        return InfoHelper.makeColumns(funcName, descr, 24) + variants.toString();
    }

    private static String makeColumns(String name, String reference, int firstColumnWidth) {
        int spaces = firstColumnWidth - name.length();
        StringBuilder result = new StringBuilder(name);
        for (int i = 0; i < spaces; ++i) {
            result.append(' ');
        }
        result.append(reference);
        return result.toString();
    }
}

