/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp;

import com.igormaznitsa.jcp.InfoHelper;
import com.igormaznitsa.jcp.cmdline.AllowWhitespaceDirectiveHandler;
import com.igormaznitsa.jcp.cmdline.CareForLastEolHandler;
import com.igormaznitsa.jcp.cmdline.ClearTargetHandler;
import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.cmdline.DestinationDirectoryHandler;
import com.igormaznitsa.jcp.cmdline.DontOverwriteSameContentHandler;
import com.igormaznitsa.jcp.cmdline.ExcludeFoldersHandler;
import com.igormaznitsa.jcp.cmdline.ExcludedFileExtensionsHandler;
import com.igormaznitsa.jcp.cmdline.FileExtensionsHandler;
import com.igormaznitsa.jcp.cmdline.GlobalVariableDefiningFileHandler;
import com.igormaznitsa.jcp.cmdline.GlobalVariableHandler;
import com.igormaznitsa.jcp.cmdline.HelpHandler;
import com.igormaznitsa.jcp.cmdline.InCharsetHandler;
import com.igormaznitsa.jcp.cmdline.KeepAttributesHandler;
import com.igormaznitsa.jcp.cmdline.KeepLineHandler;
import com.igormaznitsa.jcp.cmdline.OutCharsetHandler;
import com.igormaznitsa.jcp.cmdline.PreserveIndentDirectiveHandler;
import com.igormaznitsa.jcp.cmdline.RemoveCommentsHandler;
import com.igormaznitsa.jcp.cmdline.SourceDirectoryHandler;
import com.igormaznitsa.jcp.cmdline.UnknownAsFalseHandler;
import com.igormaznitsa.jcp.cmdline.VerboseHandler;
import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.ExcludeIfDirectiveHandler;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import hidden.jcp.org.apache.commons.io.FileUtils;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import hidden.jcp.org.springframework.util.AntPathMatcher;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public final class JcpPreprocessor {
    private static final String PROPERTY_JCP_BASE_DIR = "jcp.base.dir";
    static final CommandLineHandler[] COMMAND_LINE_HANDLERS = new CommandLineHandler[]{new HelpHandler(), new InCharsetHandler(), new OutCharsetHandler(), new ClearTargetHandler(), new SourceDirectoryHandler(), new DestinationDirectoryHandler(), new FileExtensionsHandler(), new ExcludedFileExtensionsHandler(), new AllowWhitespaceDirectiveHandler(), new RemoveCommentsHandler(), new KeepLineHandler(), new DontOverwriteSameContentHandler(), new VerboseHandler(), new GlobalVariableDefiningFileHandler(), new GlobalVariableHandler(), new CareForLastEolHandler(), new PreserveIndentDirectiveHandler(), new ExcludeFoldersHandler(), new KeepAttributesHandler(), new UnknownAsFalseHandler()};
    private final PreprocessorContext context;

    public JcpPreprocessor(PreprocessorContext context) {
        Objects.requireNonNull(context, "Configurator is null");
        this.context = context;
    }

    public static List<CommandLineHandler> getCommandLineHandlers() {
        return Arrays.asList(COMMAND_LINE_HANDLERS);
    }

    public static void main(String ... args) {
        JcpPreprocessor.printHeader();
        String[] normalizedStrings = PreprocessorUtils.replaceStringPrefix(new String[]{"--", "-"}, "/", PreprocessorUtils.replaceChar(args, '$', '\"'));
        PreprocessorContext preprocessorContext = null;
        File baseDir = JcpPreprocessor.getBaseDir();
        System.out.println("Base directory: " + baseDir);
        try {
            preprocessorContext = JcpPreprocessor.processCommandLine(baseDir, args, normalizedStrings);
        }
        catch (Exception ex) {
            System.err.println("Error during CLI processing: " + ex.getMessage());
            System.exit(1);
        }
        JcpPreprocessor preprocessor = new JcpPreprocessor(preprocessorContext);
        try {
            preprocessor.execute();
        }
        catch (Exception unexpected) {
            System.err.println(PreprocessorException.referenceAsString(' ', unexpected));
            System.exit(1);
        }
        System.exit(0);
    }

    private static File getBaseDir() {
        String baseDirInProperties = System.getProperty(PROPERTY_JCP_BASE_DIR, System.getProperty("user.dir", new File("").getAbsolutePath()));
        return new File(baseDirInProperties);
    }

    private static PreprocessorContext processCommandLine(File baseDir, String[] originalStrings, String[] normalizedStrings) {
        PreprocessorContext result = new PreprocessorContext(baseDir);
        for (int i = 0; i < normalizedStrings.length; ++i) {
            String arg = normalizedStrings[i];
            boolean processed = false;
            for (CommandLineHandler processor : JcpPreprocessor.getCommandLineHandlers()) {
                if (!processor.processCommandLineKey(arg, result)) continue;
                processed = true;
                if (!(processor instanceof HelpHandler)) break;
                JcpPreprocessor.help();
                System.exit(2);
                break;
            }
            if (processed) continue;
            System.err.println("Can't process CLI argument, see manual: " + originalStrings[i]);
            System.out.println();
            JcpPreprocessor.help();
            System.exit(1);
        }
        return result;
    }

    private static void printHeader() {
        System.out.println(InfoHelper.getProductName() + ' ' + InfoHelper.getVersion());
        System.out.println(InfoHelper.getSite());
        System.out.println(InfoHelper.getCopyright());
    }

    private static void help() {
        System.out.println();
        InfoHelper.makeTextForHelpInfo().forEach(System.out::println);
    }

    public PreprocessorContext getContext() {
        return this.context;
    }

    public Statistics execute() throws IOException {
        long timeStart = System.currentTimeMillis();
        this.context.getActivatedConfigFiles().addAll(this.processConfigFiles());
        this.context.logInfo(String.format("File extensions: %s excluded %s", this.context.getExtensions(), this.context.getExcludeExtensions()));
        List<PreprocessorContext.SourceFolder> srcFolders = this.context.getSources();
        this.context.logDebug("Source folders: " + srcFolders);
        if (srcFolders.isEmpty()) {
            this.context.logWarning("Source folder list is empty!");
        }
        Collection<FileInfoContainer> filesToBePreprocessed = this.collectFilesToPreprocess(srcFolders, this.context.getExcludeFolders());
        this.context.addAllPreprocessedResources(filesToBePreprocessed);
        List<PreprocessingState.ExcludeIfInfo> excludedIf = this.processGlobalDirectives(filesToBePreprocessed);
        this.processFileExclusion(excludedIf);
        if (!this.context.isDryRun()) {
            this.createTargetFolder();
        } else {
            this.context.logInfo("Dry run mode is ON");
        }
        Statistics stat = this.preprocessFiles(filesToBePreprocessed);
        long elapsedTime = System.currentTimeMillis() - timeStart;
        this.context.logInfo("-----------------------------------------------------------------");
        this.context.logInfo(String.format("Preprocessed %d files, copied %d files, ignored %d files, elapsed time %d ms", stat.getPreprocessed(), stat.getCopied(), stat.getExcluded(), elapsedTime));
        return stat;
    }

    private void processFileExclusion(List<PreprocessingState.ExcludeIfInfo> foundExcludeIf) {
        String DIRECTIVE_NAME = new ExcludeIfDirectiveHandler().getFullName();
        for (PreprocessingState.ExcludeIfInfo item : foundExcludeIf) {
            Value val;
            String condition = item.getCondition();
            File file = item.getFileInfoContainer().getSourceFile();
            if (this.context.isVerbose()) {
                this.context.logForVerbose(String.format("Processing condition '%s' for file '%s'", condition, file.getAbsolutePath()));
            }
            try {
                val = Expression.evalExpression(condition, this.context);
            }
            catch (PreprocessorException ex) {
                throw new PreprocessorException(ex.getMessage(), condition, new FilePositionInfo[]{new FilePositionInfo(file, item.getStringIndex())}, ex.getCause());
            }
            catch (IllegalArgumentException ex) {
                throw new PreprocessorException("Wrong expression at " + DIRECTIVE_NAME, condition, new FilePositionInfo[]{new FilePositionInfo(file, item.getStringIndex())}, ex);
            }
            if (val.getType() != ValueType.BOOLEAN) {
                throw new PreprocessorException("Expression at " + DIRECTIVE_NAME + " is not a boolean one", condition, new FilePositionInfo[]{new FilePositionInfo(file, item.getStringIndex())}, null);
            }
            if (!val.asBoolean().booleanValue()) continue;
            item.getFileInfoContainer().setExcluded(true);
            if (!this.context.isVerbose()) continue;
            this.context.logForVerbose(String.format("File '%s' excluded for active '%s' condition", file.getAbsolutePath(), condition));
        }
    }

    private List<PreprocessingState.ExcludeIfInfo> processGlobalDirectives(Collection<FileInfoContainer> files) throws IOException {
        ArrayList<PreprocessingState.ExcludeIfInfo> result = new ArrayList<PreprocessingState.ExcludeIfInfo>();
        for (FileInfoContainer fileRef : files) {
            if (fileRef.isExcludedFromPreprocessing() || fileRef.isCopyOnly()) continue;
            long startTime = System.currentTimeMillis();
            result.addAll(fileRef.processGlobalDirectives(null, this.context));
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (!this.context.isVerbose()) continue;
            this.context.logForVerbose(String.format("Global phase completed for file '%s', elapsed time %d ms ", PreprocessorUtils.getFilePath(fileRef.getSourceFile()), elapsedTime));
        }
        return result;
    }

    private Statistics preprocessFiles(Collection<FileInfoContainer> files) throws IOException {
        int preprocessedCounter = 0;
        int copiedCounter = 0;
        int excludedCounter = 0;
        for (FileInfoContainer fileRef : files) {
            if (fileRef.isExcludedFromPreprocessing()) {
                ++excludedCounter;
                continue;
            }
            if (fileRef.isCopyOnly()) {
                if (this.context.isDryRun()) continue;
                File destinationFile = this.context.createDestinationFileForPath(fileRef.makeTargetFilePathAsString());
                boolean doCopy = true;
                if (this.context.isDontOverwriteSameContent() && PreprocessorUtils.isFileContentEquals(fileRef.getSourceFile(), destinationFile)) {
                    doCopy = false;
                    if (this.context.isVerbose()) {
                        this.context.logForVerbose(String.format("Copy skipped because same content: %s -> {dst} %s", PreprocessorUtils.getFilePath(fileRef.getSourceFile()), fileRef.makeTargetFilePathAsString()));
                    }
                }
                if (!doCopy) continue;
                if (this.context.isVerbose()) {
                    this.context.logForVerbose(String.format("Copy file %s -> {dst} %s", PreprocessorUtils.getFilePath(fileRef.getSourceFile()), fileRef.makeTargetFilePathAsString()));
                }
                PreprocessorUtils.copyFile(fileRef.getSourceFile(), destinationFile, this.context.isKeepAttributes());
                fileRef.getGeneratedResources().add(destinationFile);
                ++copiedCounter;
                continue;
            }
            long startTime = System.currentTimeMillis();
            fileRef.preprocessFile(null, this.context);
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (this.context.isVerbose()) {
                this.context.logForVerbose(String.format("File preprocessing completed  '%s', elapsed time %d ms", PreprocessorUtils.getFilePath(fileRef.getSourceFile()), elapsedTime));
            }
            ++preprocessedCounter;
        }
        return new Statistics(preprocessedCounter, copiedCounter, excludedCounter);
    }

    private void createTargetFolder() throws IOException {
        File target = this.context.getTarget();
        boolean targetExists = target.isDirectory();
        if (this.context.isClearTarget() && targetExists) {
            this.context.logForVerbose("Cleaining target folder: " + target);
            try {
                FileUtils.cleanDirectory(target);
            }
            catch (IOException ex) {
                throw new IOException("Can't clean folder: " + PreprocessorUtils.getFilePath(target), ex);
            }
        }
        if (!targetExists && !target.mkdirs()) {
            throw new IOException("Can't make folder: " + PreprocessorUtils.getFilePath(target));
        }
        this.context.logForVerbose("Target folder has been prepared: " + target);
    }

    private Collection<FileInfoContainer> collectFilesToPreprocess(List<PreprocessorContext.SourceFolder> sources, List<String> excluded) throws IOException {
        ArrayList<FileInfoContainer> result = new ArrayList<FileInfoContainer>();
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (PreprocessorContext.SourceFolder sourceFolder : sources) {
            String canonicalSourcePath = sourceFolder.getAsFile().getCanonicalPath();
            this.context.logDebug("Processing folder: " + sourceFolder);
            if (!canonicalSourcePath.endsWith(File.separator)) {
                canonicalSourcePath = canonicalSourcePath + File.separator;
            }
            for (File file : this.findAllFiles(canonicalSourcePath, sourceFolder.getAsFile(), antPathMatcher, excluded)) {
                if (this.context.isFileExcludedByExtension(file)) {
                    this.context.logForVerbose(String.format("File '%s' excluded by its extension", file.getPath()));
                    continue;
                }
                String canonicalFilePath = file.getCanonicalPath();
                String canonicalRelativePath = canonicalFilePath.substring(canonicalSourcePath.length());
                FileInfoContainer reference = new FileInfoContainer(file, canonicalRelativePath, !this.context.isFileAllowedForPreprocessing(file));
                result.add(reference);
                this.context.logDebug("File added to preprocess list: " + reference);
            }
        }
        return result;
    }

    private Set<File> findAllFiles(String sourceCanonicalPath, File dir, AntPathMatcher antPathMatcher, List<String> excludedFolderPatterns) throws IOException {
        HashSet<File> result = new HashSet<File>();
        this.context.logDebug("Looking for files in folder: " + dir);
        File[] allowedFiles = dir.listFiles();
        if (allowedFiles == null) {
            this.context.logWarning("Can't find files in folder: " + dir);
        } else {
            String normalizedBasePath = FilenameUtils.normalize(sourceCanonicalPath, true);
            for (File file : allowedFiles) {
                if (file.isDirectory()) {
                    String folderPath = file.getCanonicalPath();
                    String excludedFolderPattern = null;
                    if (!excludedFolderPatterns.isEmpty()) {
                        String subPathInBase = folderPath.substring(normalizedBasePath.length());
                        for (String pattern : excludedFolderPatterns) {
                            if (!antPathMatcher.match(pattern, subPathInBase)) continue;
                            excludedFolderPattern = pattern;
                            break;
                        }
                    }
                    if (excludedFolderPattern == null) {
                        result.addAll(this.findAllFiles(sourceCanonicalPath, file, antPathMatcher, excludedFolderPatterns));
                        continue;
                    }
                    this.context.logForVerbose(String.format("Folder '%s' excluded by '%s'", folderPath, excludedFolderPattern));
                    continue;
                }
                result.add(file);
            }
        }
        return result;
    }

    List<File> processConfigFiles() throws IOException {
        ArrayList<File> processedConfigFileList = new ArrayList<File>();
        for (File file : this.context.getConfigFiles()) {
            processedConfigFileList.add(file);
            String[] lines = PreprocessorUtils.readWholeTextFileIntoArray(file, StandardCharsets.UTF_8, null);
            int readStringIndex = -1;
            for (String curString : lines) {
                String trimmed = curString.trim();
                ++readStringIndex;
                if (trimmed.isEmpty() || trimmed.charAt(0) == '#') continue;
                if (trimmed.charAt(0) == '@') {
                    PreprocessorUtils.throwPreprocessorException("Config file doesn't allow have lines started with '@'", trimmed, file, readStringIndex, null);
                    continue;
                }
                if (trimmed.charAt(0) == '/') {
                    boolean processed = false;
                    try {
                        for (CommandLineHandler handler : JcpPreprocessor.getCommandLineHandlers()) {
                            if (this.context.isVerbose()) {
                                this.context.logForVerbose(String.format("Processing \u0441onfig file key '%s' at %s:%d", trimmed, file.getName(), readStringIndex + 1));
                            }
                            if (!handler.processCommandLineKey(trimmed, this.context)) continue;
                            processed = true;
                            break;
                        }
                    }
                    catch (Exception unexpected) {
                        PreprocessorUtils.throwPreprocessorException("Exception during directive processing", trimmed, file, readStringIndex, unexpected);
                    }
                    if (processed) continue;
                    PreprocessorUtils.throwPreprocessorException("Unsupported or disallowed directive", trimmed, file, readStringIndex, null);
                    continue;
                }
                String[] split = PreprocessorUtils.splitForEqualChar(trimmed);
                if (split.length != 2) {
                    PreprocessorUtils.throwPreprocessorException("Wrong variable definition", trimmed, file, readStringIndex, null);
                }
                String name = split[0].trim().toLowerCase(Locale.ENGLISH);
                String expression = split[1].trim();
                if (name.isEmpty()) {
                    PreprocessorUtils.throwPreprocessorException("Empty variable name detected", trimmed, file, readStringIndex, null);
                }
                try {
                    Value result = Expression.evalExpression(expression, this.context);
                    this.context.setGlobalVariable(name, result);
                    if (!this.context.isVerbose()) continue;
                    this.context.logForVerbose(String.format("Registering global variable '%s' = '%s' (%s:%d)", name, result.toString(), file.getName(), readStringIndex + 1));
                }
                catch (Exception unexpected) {
                    PreprocessorUtils.throwPreprocessorException("Can't process the global variable definition", trimmed, file, readStringIndex, unexpected);
                }
            }
        }
        return processedConfigFileList;
    }

    public static final class Statistics {
        private final int preprocessed;
        private final int copied;
        private final int excluded;

        public Statistics(int preprocessed, int copied, int excluded) {
            this.preprocessed = preprocessed;
            this.copied = copied;
            this.excluded = excluded;
        }

        public int getPreprocessed() {
            return this.preprocessed;
        }

        public int getCopied() {
            return this.copied;
        }

        public int getExcluded() {
            return this.excluded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Statistics)) {
                return false;
            }
            Statistics other = (Statistics)o;
            if (this.getPreprocessed() != other.getPreprocessed()) {
                return false;
            }
            if (this.getCopied() != other.getCopied()) {
                return false;
            }
            return this.getExcluded() == other.getExcluded();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPreprocessed();
            result = result * 59 + this.getCopied();
            result = result * 59 + this.getExcluded();
            return result;
        }

        public String toString() {
            return "JcpPreprocessor.Statistics(preprocessed=" + this.getPreprocessed() + ", copied=" + this.getCopied() + ", excluded=" + this.getExcluded() + ")";
        }
    }
}

