/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.ant;

import com.igormaznitsa.jcp.JcpPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.utils.GetUtils;
import hidden.jcp.org.apache.commons.text.StringEscapeUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class PreprocessTask
extends Task
implements PreprocessorLogger,
SpecialVariableProcessor {
    private Sources sources = null;
    private String eol = null;
    private boolean keepAttributes = false;
    private String target = null;
    private String sourceEncoding = null;
    private String targetEncoding = null;
    private boolean ignoreMissingSources = false;
    private ExcludeExtensions excludeExtensions = null;
    private Extensions extensions = null;
    private boolean unknownVarAsFalse = false;
    private boolean dryRun = false;
    private boolean verbose = false;
    private boolean clearTarget = false;
    private boolean careForLastEol = false;
    private boolean keepComments = false;
    private Vars vars = null;
    private ExcludeFolders excludeFolders = null;
    private ConfigFiles configFiles = null;
    private boolean keepLines = true;
    private boolean allowWhitespaces = false;
    private boolean preserveIndents = false;
    private boolean dontOverwriteSameContent = false;
    private Map<String, Value> antVariables = new HashMap<String, Value>();

    private void registerConfigFiles(PreprocessorContext context) {
        if (this.getConfigFiles() != null) {
            for (Sources.Path f : this.getConfigFiles().getPaths()) {
                this.log("Registering config file: " + f.getValue());
                context.registerConfigFile(new File(Objects.requireNonNull(f, "File must not be null").getValue().trim()));
            }
        }
    }

    private void fillGlobalVars(PreprocessorContext context) {
        if (this.getVars() != null) {
            for (Vars.Var g : this.getVars().getVars()) {
                context.setGlobalVariable(Objects.requireNonNull(g.getName(), "Name must not be null"), Value.recognizeRawString(Objects.requireNonNull(g.getValue(), "Value must not be null")));
            }
        }
    }

    PreprocessorContext makePreprocessorContext() {
        this.fillAntVariables();
        PreprocessorContext context = new PreprocessorContext(this.getProject().getBaseDir());
        context.setPreprocessorLogger(this);
        context.registerSpecialVariableProcessor(this);
        if (this.getTarget() != null) {
            context.setTarget(new File(this.getTarget()));
        }
        if (this.getSources() != null) {
            context.setSources(this.getSources().getPaths().stream().map(Sources.Path::getValue).collect(Collectors.toList()));
        }
        if (this.getExcludeExtensions() != null) {
            context.setExcludeExtensions(this.getExcludeExtensions().extensions.stream().map(x -> ((Extensions.Extension)x).name.trim()).filter(x -> !x.isEmpty()).collect(Collectors.toList()));
        }
        if (this.getExtensions() != null) {
            context.setExtensions(this.getExtensions().extensions.stream().map(x -> ((Extensions.Extension)x).name.trim()).filter(x -> !x.isEmpty()).collect(Collectors.toList()));
        }
        if (this.getSourceEncoding() != null) {
            context.setSourceEncoding(Charset.forName(this.getSourceEncoding()));
        }
        if (this.getTargetEncoding() != null) {
            context.setTargetEncoding(Charset.forName(this.getTargetEncoding()));
        }
        context.setDontOverwriteSameContent(this.isDontOverwriteSameContent());
        context.setClearTarget(this.isClearTarget());
        context.setDryRun(this.isDryRun());
        context.setKeepComments(this.isKeepComments());
        context.setVerbose(this.isVerbose());
        context.setKeepLines(this.isKeepLines());
        context.setCareForLastEol(this.isCareForLastEol());
        context.setAllowWhitespaces(this.isAllowWhitespaces());
        context.setPreserveIndents(this.isPreserveIndents());
        context.setKeepAttributes(this.isKeepAttributes());
        context.setUnknownVariableAsFalse(this.isUnknownVarAsFalse());
        if (this.getEol() != null) {
            context.setEol(StringEscapeUtils.unescapeJava(this.getEol()));
        }
        if (this.getExcludeFolders() != null) {
            context.setExcludeFolders(this.getExcludeFolders().getFolders().stream().map(ExcludeFolders.Folder::getPath).collect(Collectors.toList()));
        }
        this.registerConfigFiles(context);
        this.fillGlobalVars(context);
        return context;
    }

    public void execute() throws BuildException {
        PreprocessorContext context;
        this.antVariables.clear();
        this.antVariables.putAll(this.fillAntVariables());
        try {
            context = this.makePreprocessorContext();
        }
        catch (Exception unexpected) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
            throw new BuildException(pp == null ? unexpected.getMessage() : pp.toString(), (Throwable)(pp == null ? unexpected : pp));
        }
        JcpPreprocessor preprocessor = new JcpPreprocessor(context);
        try {
            preprocessor.execute();
        }
        catch (Exception unexpected) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
            throw new BuildException(pp == null ? unexpected.getMessage() : pp.toString(), (Throwable)(pp == null ? unexpected : pp));
        }
    }

    @Override
    public void error(String message) {
        this.log(message, 0);
    }

    @Override
    public void info(String message) {
        this.log(message, 2);
    }

    @Override
    public void debug(String message) {
        this.log(message, 4);
    }

    @Override
    public void warning(String message) {
        this.log(message, 1);
    }

    private Map<String, Value> fillAntVariables() {
        Map<String, Value> result;
        Project theProject = this.getProject();
        if (theProject == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            for (Object key : this.getProject().getProperties().keySet()) {
                String keyStr = key.toString();
                String value = theProject.getProperty(keyStr);
                if (value == null) continue;
                result.put("ant." + keyStr.toLowerCase(Locale.ENGLISH), Value.valueOf(value));
            }
        }
        return result;
    }

    @Override
    public String[] getVariableNames() {
        String[] result = this.antVariables == null ? new String[]{} : this.antVariables.keySet().toArray(new String[0]);
        return result;
    }

    @Override
    public Value getVariable(String varName, PreprocessorContext context) {
        if (this.antVariables == null) {
            throw context.makeException("Non-initialized ANT property map detected", null);
        }
        Value result = this.antVariables.get(varName);
        if (result == null) {
            throw context.makeException("Request for unsupported Ant property '" + varName + '\'', null);
        }
        return result;
    }

    @Override
    public void setVariable(String varName, Value value, PreprocessorContext context) {
        throw context.makeException("Request to change ANT property '" + varName + "'. NB! ANT properties are read only!", null);
    }

    public Extensions createExtensions() {
        this.extensions = new Extensions();
        return this.extensions;
    }

    public ExcludeExtensions createExcludeExtensions() {
        this.excludeExtensions = new ExcludeExtensions();
        return this.excludeExtensions;
    }

    public ExcludeFolders createExcludeFolders() {
        this.excludeFolders = new ExcludeFolders();
        return this.excludeFolders;
    }

    public Sources createSources() {
        this.sources = new Sources();
        return this.sources;
    }

    public ConfigFiles createConfigFiles() {
        this.configFiles = new ConfigFiles();
        return this.configFiles;
    }

    public Vars createVars() {
        this.vars = new Vars();
        return this.vars;
    }

    public Sources getSources() {
        return this.sources;
    }

    public String getEol() {
        return this.eol;
    }

    public boolean isKeepAttributes() {
        return this.keepAttributes;
    }

    public String getTarget() {
        return this.target;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public boolean isIgnoreMissingSources() {
        return this.ignoreMissingSources;
    }

    public ExcludeExtensions getExcludeExtensions() {
        return this.excludeExtensions;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public boolean isUnknownVarAsFalse() {
        return this.unknownVarAsFalse;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isClearTarget() {
        return this.clearTarget;
    }

    public boolean isCareForLastEol() {
        return this.careForLastEol;
    }

    public boolean isKeepComments() {
        return this.keepComments;
    }

    public Vars getVars() {
        return this.vars;
    }

    public ExcludeFolders getExcludeFolders() {
        return this.excludeFolders;
    }

    public ConfigFiles getConfigFiles() {
        return this.configFiles;
    }

    public boolean isKeepLines() {
        return this.keepLines;
    }

    public boolean isAllowWhitespaces() {
        return this.allowWhitespaces;
    }

    public boolean isPreserveIndents() {
        return this.preserveIndents;
    }

    public boolean isDontOverwriteSameContent() {
        return this.dontOverwriteSameContent;
    }

    public Map<String, Value> getAntVariables() {
        return this.antVariables;
    }

    public void setSources(Sources sources) {
        this.sources = sources;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public void setKeepAttributes(boolean keepAttributes) {
        this.keepAttributes = keepAttributes;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setTargetEncoding(String targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    public void setIgnoreMissingSources(boolean ignoreMissingSources) {
        this.ignoreMissingSources = ignoreMissingSources;
    }

    public void setExcludeExtensions(ExcludeExtensions excludeExtensions) {
        this.excludeExtensions = excludeExtensions;
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public void setUnknownVarAsFalse(boolean unknownVarAsFalse) {
        this.unknownVarAsFalse = unknownVarAsFalse;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setClearTarget(boolean clearTarget) {
        this.clearTarget = clearTarget;
    }

    public void setCareForLastEol(boolean careForLastEol) {
        this.careForLastEol = careForLastEol;
    }

    public void setKeepComments(boolean keepComments) {
        this.keepComments = keepComments;
    }

    public void setVars(Vars vars) {
        this.vars = vars;
    }

    public void setExcludeFolders(ExcludeFolders excludeFolders) {
        this.excludeFolders = excludeFolders;
    }

    public void setConfigFiles(ConfigFiles configFiles) {
        this.configFiles = configFiles;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public void setAllowWhitespaces(boolean allowWhitespaces) {
        this.allowWhitespaces = allowWhitespaces;
    }

    public void setPreserveIndents(boolean preserveIndents) {
        this.preserveIndents = preserveIndents;
    }

    public void setDontOverwriteSameContent(boolean dontOverwriteSameContent) {
        this.dontOverwriteSameContent = dontOverwriteSameContent;
    }

    public void setAntVariables(Map<String, Value> antVariables) {
        this.antVariables = antVariables;
    }

    public String toString() {
        return "PreprocessTask(sources=" + this.getSources() + ", eol=" + this.getEol() + ", keepAttributes=" + this.isKeepAttributes() + ", target=" + this.getTarget() + ", sourceEncoding=" + this.getSourceEncoding() + ", targetEncoding=" + this.getTargetEncoding() + ", ignoreMissingSources=" + this.isIgnoreMissingSources() + ", excludeExtensions=" + this.getExcludeExtensions() + ", extensions=" + this.getExtensions() + ", unknownVarAsFalse=" + this.isUnknownVarAsFalse() + ", dryRun=" + this.isDryRun() + ", verbose=" + this.isVerbose() + ", clearTarget=" + this.isClearTarget() + ", careForLastEol=" + this.isCareForLastEol() + ", keepComments=" + this.isKeepComments() + ", vars=" + this.getVars() + ", excludeFolders=" + this.getExcludeFolders() + ", configFiles=" + this.getConfigFiles() + ", keepLines=" + this.isKeepLines() + ", allowWhitespaces=" + this.isAllowWhitespaces() + ", preserveIndents=" + this.isPreserveIndents() + ", dontOverwriteSameContent=" + this.isDontOverwriteSameContent() + ", antVariables=" + this.getAntVariables() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreprocessTask)) {
            return false;
        }
        PreprocessTask other = (PreprocessTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKeepAttributes() != other.isKeepAttributes()) {
            return false;
        }
        if (this.isIgnoreMissingSources() != other.isIgnoreMissingSources()) {
            return false;
        }
        if (this.isUnknownVarAsFalse() != other.isUnknownVarAsFalse()) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isVerbose() != other.isVerbose()) {
            return false;
        }
        if (this.isClearTarget() != other.isClearTarget()) {
            return false;
        }
        if (this.isCareForLastEol() != other.isCareForLastEol()) {
            return false;
        }
        if (this.isKeepComments() != other.isKeepComments()) {
            return false;
        }
        if (this.isKeepLines() != other.isKeepLines()) {
            return false;
        }
        if (this.isAllowWhitespaces() != other.isAllowWhitespaces()) {
            return false;
        }
        if (this.isPreserveIndents() != other.isPreserveIndents()) {
            return false;
        }
        if (this.isDontOverwriteSameContent() != other.isDontOverwriteSameContent()) {
            return false;
        }
        Sources this$sources = this.getSources();
        Sources other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        String this$eol = this.getEol();
        String other$eol = other.getEol();
        if (this$eol == null ? other$eol != null : !this$eol.equals(other$eol)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$sourceEncoding = this.getSourceEncoding();
        String other$sourceEncoding = other.getSourceEncoding();
        if (this$sourceEncoding == null ? other$sourceEncoding != null : !this$sourceEncoding.equals(other$sourceEncoding)) {
            return false;
        }
        String this$targetEncoding = this.getTargetEncoding();
        String other$targetEncoding = other.getTargetEncoding();
        if (this$targetEncoding == null ? other$targetEncoding != null : !this$targetEncoding.equals(other$targetEncoding)) {
            return false;
        }
        ExcludeExtensions this$excludeExtensions = this.getExcludeExtensions();
        ExcludeExtensions other$excludeExtensions = other.getExcludeExtensions();
        if (this$excludeExtensions == null ? other$excludeExtensions != null : !((Object)this$excludeExtensions).equals(other$excludeExtensions)) {
            return false;
        }
        Extensions this$extensions = this.getExtensions();
        Extensions other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        Vars this$vars = this.getVars();
        Vars other$vars = other.getVars();
        if (this$vars == null ? other$vars != null : !((Object)this$vars).equals(other$vars)) {
            return false;
        }
        ExcludeFolders this$excludeFolders = this.getExcludeFolders();
        ExcludeFolders other$excludeFolders = other.getExcludeFolders();
        if (this$excludeFolders == null ? other$excludeFolders != null : !((Object)this$excludeFolders).equals(other$excludeFolders)) {
            return false;
        }
        ConfigFiles this$configFiles = this.getConfigFiles();
        ConfigFiles other$configFiles = other.getConfigFiles();
        if (this$configFiles == null ? other$configFiles != null : !((Object)this$configFiles).equals(other$configFiles)) {
            return false;
        }
        Map<String, Value> this$antVariables = this.getAntVariables();
        Map<String, Value> other$antVariables = other.getAntVariables();
        return !(this$antVariables == null ? other$antVariables != null : !((Object)this$antVariables).equals(other$antVariables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreprocessTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepAttributes() ? 79 : 97);
        result = result * 59 + (this.isIgnoreMissingSources() ? 79 : 97);
        result = result * 59 + (this.isUnknownVarAsFalse() ? 79 : 97);
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isVerbose() ? 79 : 97);
        result = result * 59 + (this.isClearTarget() ? 79 : 97);
        result = result * 59 + (this.isCareForLastEol() ? 79 : 97);
        result = result * 59 + (this.isKeepComments() ? 79 : 97);
        result = result * 59 + (this.isKeepLines() ? 79 : 97);
        result = result * 59 + (this.isAllowWhitespaces() ? 79 : 97);
        result = result * 59 + (this.isPreserveIndents() ? 79 : 97);
        result = result * 59 + (this.isDontOverwriteSameContent() ? 79 : 97);
        Sources $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        String $eol = this.getEol();
        result = result * 59 + ($eol == null ? 43 : $eol.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $sourceEncoding = this.getSourceEncoding();
        result = result * 59 + ($sourceEncoding == null ? 43 : $sourceEncoding.hashCode());
        String $targetEncoding = this.getTargetEncoding();
        result = result * 59 + ($targetEncoding == null ? 43 : $targetEncoding.hashCode());
        ExcludeExtensions $excludeExtensions = this.getExcludeExtensions();
        result = result * 59 + ($excludeExtensions == null ? 43 : ((Object)$excludeExtensions).hashCode());
        Extensions $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        Vars $vars = this.getVars();
        result = result * 59 + ($vars == null ? 43 : ((Object)$vars).hashCode());
        ExcludeFolders $excludeFolders = this.getExcludeFolders();
        result = result * 59 + ($excludeFolders == null ? 43 : ((Object)$excludeFolders).hashCode());
        ConfigFiles $configFiles = this.getConfigFiles();
        result = result * 59 + ($configFiles == null ? 43 : ((Object)$configFiles).hashCode());
        Map<String, Value> $antVariables = this.getAntVariables();
        result = result * 59 + ($antVariables == null ? 43 : ((Object)$antVariables).hashCode());
        return result;
    }

    public static class ConfigFiles
    extends Sources {
        @Override
        public String toString() {
            return "PreprocessTask.ConfigFiles()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigFiles)) {
                return false;
            }
            ConfigFiles other = (ConfigFiles)o;
            return other.canEqual(this);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ConfigFiles;
        }

        @Override
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Sources {
        protected List<Path> paths = new ArrayList<Path>();

        public Path createPath() {
            Path result = new Path();
            this.paths.add(result);
            return result;
        }

        public List<Path> getPaths() {
            return this.paths;
        }

        public void setPaths(List<Path> paths) {
            this.paths = paths;
        }

        public String toString() {
            return "PreprocessTask.Sources(paths=" + this.getPaths() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sources)) {
                return false;
            }
            Sources other = (Sources)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Path> this$paths = this.getPaths();
            List<Path> other$paths = other.getPaths();
            return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sources;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Path> $paths = this.getPaths();
            result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
            return result;
        }

        public static class Path {
            private String value = "";

            public void addText(String text) {
                this.value = this.value + GetUtils.ensureNonNull(text, "");
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Path)) {
                    return false;
                }
                Path other = (Path)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Path;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "PreprocessTask.Sources.Path(value=" + this.getValue() + ")";
            }
        }
    }

    public static class Vars {
        private List<Var> vars = new ArrayList<Var>();

        public Var createVar() {
            Var result = new Var();
            this.vars.add(result);
            return result;
        }

        public List<Var> getVars() {
            return this.vars;
        }

        public void setVars(List<Var> vars) {
            this.vars = vars;
        }

        public String toString() {
            return "PreprocessTask.Vars(vars=" + this.getVars() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vars)) {
                return false;
            }
            Vars other = (Vars)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Var> this$vars = this.getVars();
            List<Var> other$vars = other.getVars();
            return !(this$vars == null ? other$vars != null : !((Object)this$vars).equals(other$vars));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Vars;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Var> $vars = this.getVars();
            result = result * 59 + ($vars == null ? 43 : ((Object)$vars).hashCode());
            return result;
        }

        public static class Var {
            private String name = "";
            private String value = "";

            public void addText(String text) {
                this.value = this.value + text;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String toString() {
                return "PreprocessTask.Vars.Var(name=" + this.getName() + ", value=" + this.getValue() + ")";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Var)) {
                    return false;
                }
                Var other = (Var)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Var;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class ExcludeExtensions
    extends Extensions {
        @Override
        public String toString() {
            return "PreprocessTask.ExcludeExtensions()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExcludeExtensions)) {
                return false;
            }
            ExcludeExtensions other = (ExcludeExtensions)o;
            return other.canEqual(this);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ExcludeExtensions;
        }

        @Override
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Extensions {
        protected final List<Extension> extensions = new ArrayList<Extension>();

        public Extension createExtension() {
            Extension result = new Extension();
            this.extensions.add(result);
            return result;
        }

        public List<Extension> getExtensions() {
            return this.extensions;
        }

        public String toString() {
            return "PreprocessTask.Extensions(extensions=" + this.getExtensions() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Extensions)) {
                return false;
            }
            Extensions other = (Extensions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Extension> this$extensions = this.getExtensions();
            List<Extension> other$extensions = other.getExtensions();
            return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Extensions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Extension> $extensions = this.getExtensions();
            result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
            return result;
        }

        public static class Extension {
            private String name = "";

            public void addText(String text) {
                this.name = this.name + GetUtils.ensureNonNull(text, "");
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Extension)) {
                    return false;
                }
                Extension other = (Extension)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Extension;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            public String toString() {
                return "PreprocessTask.Extensions.Extension(name=" + this.getName() + ")";
            }
        }
    }

    public static class ExcludeFolders {
        private List<Folder> folders = new ArrayList<Folder>();

        public Folder createFolder() {
            Folder result = new Folder();
            this.folders.add(result);
            return result;
        }

        public List<Folder> getFolders() {
            return this.folders;
        }

        public void setFolders(List<Folder> folders) {
            this.folders = folders;
        }

        public String toString() {
            return "PreprocessTask.ExcludeFolders(folders=" + this.getFolders() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExcludeFolders)) {
                return false;
            }
            ExcludeFolders other = (ExcludeFolders)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Folder> this$folders = this.getFolders();
            List<Folder> other$folders = other.getFolders();
            return !(this$folders == null ? other$folders != null : !((Object)this$folders).equals(other$folders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExcludeFolders;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Folder> $folders = this.getFolders();
            result = result * 59 + ($folders == null ? 43 : ((Object)$folders).hashCode());
            return result;
        }

        public static class Folder {
            private String path = "";

            public void addText(String text) {
                this.path = GetUtils.ensureNonNull(text, "");
            }

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Folder)) {
                    return false;
                }
                Folder other = (Folder)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$path = this.getPath();
                String other$path = other.getPath();
                return !(this$path == null ? other$path != null : !this$path.equals(other$path));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Folder;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                return result;
            }

            public String toString() {
                return "PreprocessTask.ExcludeFolders.Folder(path=" + this.getPath() + ")";
            }
        }
    }
}

