/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public class ExcludedFileExtensionsHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/EF:";

    @Override
    public String getDescription() {
        return "comma separated file extensions (case insensetive) to be excluded from preprocess and copy (by default " + String.join((CharSequence)",", PreprocessorContext.DEFAULT_EXCLUDED_EXTENSIONS) + ')';
    }

    @Override
    public boolean processCommandLineKey(String key, PreprocessorContext context) {
        String extensions;
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(extensions = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty()) {
            context.setExcludeExtensions(Arrays.stream(extensions.split("\\,")).map(String::trim).collect(Collectors.toList()));
            result = true;
        }
        return result;
    }

    @Override
    public String getKeyName() {
        return ARG_NAME;
    }
}

