/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.containers;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.jcp.utils.ResetablePrinter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileInfoContainer {
    public static final String WARNING_SPACE_BEFORE_HASH = "Detected hash prefixed comment line with whitespace, directive may be lost: ";
    private static final Pattern DIRECTIVE_HASH_PREFIXED = Pattern.compile("^\\s*//\\s*#(.*)$");
    private static final Pattern DIRECTIVE_TWO_DOLLARS_PREFIXED = Pattern.compile("^\\s*//\\s*\\$\\$(.*)$");
    private static final Pattern DIRECTIVE_SINGLE_DOLLAR_PREFIXED = Pattern.compile("^\\s*//\\s*\\$(.*)$");
    private static final Pattern DIRECTIVE_TAIL_REMOVER = Pattern.compile("\\/\\*\\s*-\\s*\\*\\/");
    private final File sourceFile;
    private final boolean copyOnly;
    private final Collection<File> generatedResources = new HashSet<File>();
    private final Collection<File> includedSources = new HashSet<File>();
    private boolean excludedFromPreprocessing;
    private String targetFolder;
    private String targetFileName;

    public FileInfoContainer(File srcFile, String targetFileName, boolean copyOnly) {
        Objects.requireNonNull(srcFile, "Source file is null");
        Objects.requireNonNull(targetFileName, "Target file name is null");
        this.copyOnly = copyOnly;
        this.excludedFromPreprocessing = false;
        this.sourceFile = srcFile;
        int lastDirSeparator = targetFileName.lastIndexOf(47);
        if (lastDirSeparator < 0) {
            lastDirSeparator = targetFileName.lastIndexOf(92);
        }
        if (lastDirSeparator < 0) {
            this.targetFolder = "." + File.separatorChar;
            this.targetFileName = targetFileName;
        } else {
            this.targetFolder = targetFileName.substring(0, lastDirSeparator);
            this.targetFileName = targetFileName.substring(lastDirSeparator + 1);
        }
    }

    private static String findTailRemover(String str, PreprocessorContext context) {
        String result = str;
        if (context.isAllowWhitespaces()) {
            Matcher matcher = DIRECTIVE_TAIL_REMOVER.matcher(str);
            if (matcher.find()) {
                result = str.substring(0, matcher.start());
            }
        } else {
            int tailRemoverStart = str.indexOf("/*-*/");
            if (tailRemoverStart >= 0) {
                result = str.substring(0, tailRemoverStart);
            }
        }
        return result;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = Objects.requireNonNull(targetFolder, "Target folder must not be null");
    }

    public void setTargetName(String targetName) {
        this.targetFileName = Objects.requireNonNull(this.targetFileName, "Target file name must not be null");
    }

    public String makeTargetFilePathAsString() {
        String targetFolder = this.getTargetFolder();
        if (!targetFolder.isEmpty() && targetFolder.charAt(targetFolder.length() - 1) != File.separatorChar) {
            targetFolder = targetFolder + File.separatorChar;
        }
        return targetFolder + this.getTargetFileName();
    }

    public String toString() {
        return String.format("%s: source=%s, targetFolder=%s, targetName=%s", this.getClass().getSimpleName(), PreprocessorUtils.getFilePath(this.getSourceFile()), this.getTargetFolder(), this.getTargetFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PreprocessingState.ExcludeIfInfo> processGlobalDirectives(PreprocessingState state, PreprocessorContext context) throws IOException {
        PreprocessingState preprocessingState = state == null ? context.produceNewPreprocessingState(this, 0) : state;
        preprocessingState.setGlobalPhase(true);
        String leftTrimmedString = null;
        try {
            try {
                block8: while (!Thread.currentThread().isInterrupted()) {
                    String nonTrimmedProcessingString = preprocessingState.nextLine();
                    Set<PreprocessingFlag> processFlags = preprocessingState.getPreprocessingFlags();
                    if (processFlags.contains((Object)PreprocessingFlag.END_PROCESSING) || processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                        if (!processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                            processFlags.remove((Object)PreprocessingFlag.END_PROCESSING);
                        }
                        nonTrimmedProcessingString = null;
                    }
                    if (nonTrimmedProcessingString == null) {
                        preprocessingState.popTextContainer();
                        if (!preprocessingState.isIncludeStackEmpty()) continue;
                        break;
                    }
                    leftTrimmedString = PreprocessorUtils.leftTrim(nonTrimmedProcessingString);
                    if (!this.isHashPrefixed(leftTrimmedString, context)) continue;
                    switch (this.processDirective(preprocessingState, this.extractHashPrefixedDirective(leftTrimmedString, context), context, true)) {
                        case PROCESSED: 
                        case READ_NEXT_LINE: 
                        case SHOULD_BE_COMMENTED: {
                            continue block8;
                        }
                    }
                    throw new Error("Unsupported result");
                }
            }
            catch (Exception unexpected) {
                PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
                if (pp == null) {
                    throw preprocessingState.makeException("Unexpected exception detected", leftTrimmedString, unexpected);
                }
                throw pp;
            }
            if (!preprocessingState.isIfStackEmpty()) {
                TextFileDataContainer lastIf = Objects.requireNonNull(preprocessingState.peekIf());
                throw new PreprocessorException("Unclosed //#_if instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastIf.getFile(), lastIf.getNextStringIndex())}, null);
            }
            List<PreprocessingState.ExcludeIfInfo> list = preprocessingState.popAllExcludeIfInfoData();
            return list;
        }
        finally {
            preprocessingState.setGlobalPhase(false);
        }
    }

    private boolean isDoubleDollarPrefixed(String line, PreprocessorContext context) {
        if (context.isAllowWhitespaces()) {
            return DIRECTIVE_TWO_DOLLARS_PREFIXED.matcher(line).matches();
        }
        return line.startsWith("//$$");
    }

    private boolean isSingleDollarPrefixed(String line, PreprocessorContext context) {
        if (context.isAllowWhitespaces()) {
            return DIRECTIVE_SINGLE_DOLLAR_PREFIXED.matcher(line).matches();
        }
        return line.startsWith("//$");
    }

    private boolean isHashPrefixed(String line, PreprocessorContext context) {
        if (context.isAllowWhitespaces()) {
            return DIRECTIVE_HASH_PREFIXED.matcher(line).matches();
        }
        boolean result = line.startsWith("//#");
        if (context.getPreprocessingState().isGlobalPhase() && !result && line.startsWith("// ") && DIRECTIVE_HASH_PREFIXED.matcher(line).matches()) {
            TextFileDataContainer textContainer = context.getPreprocessingState().getCurrentIncludeFileContainer();
            String lineInfo = "<NONE>";
            if (textContainer != null) {
                lineInfo = String.format("%s:%d)", textContainer.getFile().getAbsolutePath(), textContainer.getNextStringIndex());
            }
            context.logWarning(WARNING_SPACE_BEFORE_HASH + lineInfo);
        }
        return result;
    }

    private String extractHashPrefixedDirective(String line, PreprocessorContext context) {
        if (context.isAllowWhitespaces()) {
            Matcher matcher = DIRECTIVE_HASH_PREFIXED.matcher(line);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new Error("Unexpected situation, directive is not found, contact developer! (" + line + ')');
        }
        return PreprocessorUtils.extractTail("//#", line);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String extractDoubleDollarPrefixedDirective(String line, PreprocessorContext context) {
        String tail;
        if (context.isAllowWhitespaces()) {
            Matcher matcher = DIRECTIVE_TWO_DOLLARS_PREFIXED.matcher(line);
            if (!matcher.find()) throw new Error("Unexpected situation, '//$$' directive is not found, contact developer! (" + line + ')');
            tail = matcher.group(1);
        } else {
            tail = PreprocessorUtils.extractTail("//$$", line);
        }
        if (!context.isPreserveIndents()) return tail;
        return PreprocessorUtils.replacePartByChar(line, ' ', 0, line.length() - tail.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String extractSingleDollarPrefixedDirective(String line, PreprocessorContext context) {
        String tail;
        if (context.isAllowWhitespaces()) {
            Matcher matcher = DIRECTIVE_SINGLE_DOLLAR_PREFIXED.matcher(line);
            if (!matcher.find()) throw new Error("Unexpected situation, '//$' directive is not found, contact developer! (" + line + ')');
            tail = matcher.group(1);
        } else {
            tail = PreprocessorUtils.extractTail("//$", line);
        }
        if (!context.isPreserveIndents()) return tail;
        return PreprocessorUtils.replacePartByChar(line, ' ', 0, line.length() - tail.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreprocessingState preprocessFile(PreprocessingState state, PreprocessorContext context) throws IOException {
        if (!context.isCloned()) {
            context.clearLocalVariables();
        }
        PreprocessingState preprocessingState = state == null ? context.produceNewPreprocessingState(this, 1) : state;
        String leftTrimmedString = null;
        TextFileDataContainer lastTextFileDataContainer = null;
        try {
            block6: while (!Thread.currentThread().isInterrupted()) {
                boolean doPrintLn;
                int numberOfSpacesAtTheLineBeginning;
                String rawString = preprocessingState.nextLine();
                boolean presentedNextLine = preprocessingState.hasReadLineNextLineInEnd();
                Set<PreprocessingFlag> processFlags = preprocessingState.getPreprocessingFlags();
                if (processFlags.contains((Object)PreprocessingFlag.END_PROCESSING) || processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                    if (!processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                        processFlags.remove((Object)PreprocessingFlag.END_PROCESSING);
                    }
                    rawString = null;
                }
                if (preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.END_PROCESSING)) {
                    preprocessingState.getPreprocessingFlags().remove((Object)PreprocessingFlag.END_PROCESSING);
                    rawString = null;
                }
                if (rawString == null) {
                    lastTextFileDataContainer = preprocessingState.popTextContainer();
                    if (!preprocessingState.isIncludeStackEmpty()) continue;
                    break;
                }
                leftTrimmedString = PreprocessorUtils.leftTrim(rawString);
                String stringPrefix = leftTrimmedString.isEmpty() ? rawString : ((numberOfSpacesAtTheLineBeginning = rawString.indexOf(leftTrimmedString)) > 0 ? rawString.substring(0, numberOfSpacesAtTheLineBeginning) : "");
                String stringToBeProcessed = leftTrimmedString;
                boolean bl = doPrintLn = presentedNextLine || !context.isCareForLastEol();
                if (this.isHashPrefixed(stringToBeProcessed, context)) {
                    String extractedDirective = this.extractHashPrefixedDirective(stringToBeProcessed, context);
                    switch (this.processDirective(preprocessingState, extractedDirective, context, false)) {
                        case PROCESSED: 
                        case READ_NEXT_LINE: {
                            if (!context.isKeepLines()) continue block6;
                            String text = stringPrefix + "//JCP! " + extractedDirective;
                            ResetablePrinter thePrinter = Objects.requireNonNull(preprocessingState.getPrinter());
                            if (doPrintLn) {
                                thePrinter.println(text, context.getEol());
                                continue block6;
                            }
                            thePrinter.print(text);
                            continue block6;
                        }
                        case SHOULD_BE_COMMENTED: {
                            String text = stringPrefix + "//JCP! " + extractedDirective;
                            ResetablePrinter thePrinter = Objects.requireNonNull(preprocessingState.getPrinter());
                            if (doPrintLn) {
                                thePrinter.println(text, context.getEol());
                                continue block6;
                            }
                            thePrinter.print(text);
                            continue block6;
                        }
                    }
                    throw new Error("Unsupported result");
                }
                ResetablePrinter thePrinter = Objects.requireNonNull(preprocessingState.getPrinter());
                if (preprocessingState.isDirectiveCanBeProcessed() && !preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.TEXT_OUTPUT_DISABLED)) {
                    String text;
                    boolean startsWithTwoDollars = this.isDoubleDollarPrefixed(leftTrimmedString, context);
                    if (!startsWithTwoDollars) {
                        stringToBeProcessed = PreprocessorUtils.processMacroses(leftTrimmedString, context);
                    }
                    if (startsWithTwoDollars) {
                        thePrinter.print(stringPrefix);
                        text = this.extractDoubleDollarPrefixedDirective(leftTrimmedString, context);
                        if (doPrintLn) {
                            thePrinter.println(text, context.getEol());
                            continue;
                        }
                        thePrinter.print(text);
                        continue;
                    }
                    if (this.isSingleDollarPrefixed(stringToBeProcessed, context)) {
                        thePrinter.print(stringPrefix);
                        text = this.extractSingleDollarPrefixedDirective(stringToBeProcessed, context);
                        if (doPrintLn) {
                            thePrinter.println(text, context.getEol());
                            continue;
                        }
                        thePrinter.print(text);
                        continue;
                    }
                    String strToOut = FileInfoContainer.findTailRemover(stringToBeProcessed, context);
                    if (preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.COMMENT_NEXT_LINE)) {
                        thePrinter.print("//");
                        preprocessingState.getPreprocessingFlags().remove((Object)PreprocessingFlag.COMMENT_NEXT_LINE);
                    }
                    thePrinter.print(stringPrefix);
                    if (doPrintLn) {
                        thePrinter.println(strToOut, context.getEol());
                        continue;
                    }
                    thePrinter.print(strToOut);
                    continue;
                }
                if (!context.isKeepLines()) continue;
                String text = "//JCP> " + rawString;
                if (doPrintLn) {
                    thePrinter.println(text, context.getEol());
                    continue;
                }
                thePrinter.print(text);
            }
        }
        catch (Exception unexpected) {
            String message = unexpected.getMessage() == null ? "Unexpected exception" : unexpected.getMessage();
            throw preprocessingState.makeException(message, leftTrimmedString, unexpected);
        }
        if (!preprocessingState.isIfStackEmpty()) {
            TextFileDataContainer lastIf = Objects.requireNonNull(preprocessingState.peekIf(), "'IF' stack is empty");
            throw new PreprocessorException("Unclosed //#if instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastIf.getFile(), lastIf.getNextStringIndex())}, null);
        }
        if (!preprocessingState.isWhileStackEmpty()) {
            TextFileDataContainer lastWhile = Objects.requireNonNull(preprocessingState.peekWhile(), "'WHILE' stack is empty");
            throw new PreprocessorException("Unclosed //#while instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastWhile.getFile(), lastWhile.getNextStringIndex())}, null);
        }
        if (!context.isDryRun() && ((TextFileDataContainer)Objects.requireNonNull(lastTextFileDataContainer)).isAutoFlush()) {
            File outFile = context.createDestinationFileForPath(this.makeTargetFilePathAsString());
            boolean wasSaved = preprocessingState.saveBuffersToFile(outFile, context.isKeepComments());
            if (context.isVerbose()) {
                context.logForVerbose(String.format("Content was %s into file '%s'", wasSaved ? "saved" : "not saved", outFile.toString()));
            }
            if (this.sourceFile != null && context.isKeepAttributes() && !PreprocessorUtils.copyFileAttributes(this.getSourceFile(), outFile)) {
                throw new IOException("Can't copy attributes in result file: " + outFile);
            }
            this.getGeneratedResources().add(outFile);
        }
        return preprocessingState;
    }

    private boolean checkDirectiveArgumentRoughly(AbstractDirectiveHandler directive, String rest) {
        boolean result;
        DirectiveArgumentType argument = directive.getArgumentType();
        String trimmedRest = rest.trim();
        switch (argument) {
            case NONE: {
                result = trimmedRest.isEmpty();
                break;
            }
            case ONOFF: {
                if (trimmedRest.isEmpty()) {
                    result = false;
                    break;
                }
                char firstChar = rest.charAt(0);
                boolean bl = result = firstChar == '+' || firstChar == '-';
                if (rest.length() <= 1) break;
                result = result && Character.isSpaceChar(rest.charAt(1));
                break;
            }
            case TAIL: {
                result = true;
                break;
            }
            default: {
                result = !trimmedRest.isEmpty() && Character.isSpaceChar(rest.charAt(0));
            }
        }
        return result;
    }

    protected AfterDirectiveProcessingBehaviour processDirective(PreprocessingState state, String directiveString, PreprocessorContext context, boolean firstPass) throws IOException {
        boolean executionEnabled = state.isDirectiveCanBeProcessed();
        for (AbstractDirectiveHandler handler : AbstractDirectiveHandler.getAllDirectives()) {
            String name = handler.getName();
            if (!directiveString.startsWith(name)) continue;
            if (firstPass && !handler.isGlobalPhaseAllowed() || !firstPass && !handler.isPreprocessingPhaseAllowed()) {
                return AfterDirectiveProcessingBehaviour.READ_NEXT_LINE;
            }
            boolean allowedForExecution = executionEnabled || !handler.executeOnlyWhenExecutionAllowed();
            String restOfString = PreprocessorUtils.extractTail(name, directiveString);
            if (this.checkDirectiveArgumentRoughly(handler, restOfString)) {
                if (allowedForExecution) {
                    return handler.execute(restOfString, context);
                }
                return context.isKeepLines() ? AfterDirectiveProcessingBehaviour.SHOULD_BE_COMMENTED : AfterDirectiveProcessingBehaviour.PROCESSED;
            }
            throw context.makeException("Detected bad argument for //#" + handler.getName(), null);
        }
        throw context.makeException("Unknown preprocessor directive [" + directiveString + ']', null);
    }

    public void setExcluded(boolean flag) {
        this.excludedFromPreprocessing = flag;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean isCopyOnly() {
        return this.copyOnly;
    }

    public Collection<File> getGeneratedResources() {
        return this.generatedResources;
    }

    public Collection<File> getIncludedSources() {
        return this.includedSources;
    }

    public boolean isExcludedFromPreprocessing() {
        return this.excludedFromPreprocessing;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setExcludedFromPreprocessing(boolean excludedFromPreprocessing) {
        this.excludedFromPreprocessing = excludedFromPreprocessing;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileInfoContainer)) {
            return false;
        }
        FileInfoContainer other = (FileInfoContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCopyOnly() != other.isCopyOnly()) {
            return false;
        }
        if (this.isExcludedFromPreprocessing() != other.isExcludedFromPreprocessing()) {
            return false;
        }
        File this$sourceFile = this.getSourceFile();
        File other$sourceFile = other.getSourceFile();
        if (this$sourceFile == null ? other$sourceFile != null : !((Object)this$sourceFile).equals(other$sourceFile)) {
            return false;
        }
        Collection<File> this$generatedResources = this.getGeneratedResources();
        Collection<File> other$generatedResources = other.getGeneratedResources();
        if (this$generatedResources == null ? other$generatedResources != null : !((Object)this$generatedResources).equals(other$generatedResources)) {
            return false;
        }
        Collection<File> this$includedSources = this.getIncludedSources();
        Collection<File> other$includedSources = other.getIncludedSources();
        if (this$includedSources == null ? other$includedSources != null : !((Object)this$includedSources).equals(other$includedSources)) {
            return false;
        }
        String this$targetFolder = this.getTargetFolder();
        String other$targetFolder = other.getTargetFolder();
        if (this$targetFolder == null ? other$targetFolder != null : !this$targetFolder.equals(other$targetFolder)) {
            return false;
        }
        String this$targetFileName = this.getTargetFileName();
        String other$targetFileName = other.getTargetFileName();
        return !(this$targetFileName == null ? other$targetFileName != null : !this$targetFileName.equals(other$targetFileName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileInfoContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCopyOnly() ? 79 : 97);
        result = result * 59 + (this.isExcludedFromPreprocessing() ? 79 : 97);
        File $sourceFile = this.getSourceFile();
        result = result * 59 + ($sourceFile == null ? 43 : ((Object)$sourceFile).hashCode());
        Collection<File> $generatedResources = this.getGeneratedResources();
        result = result * 59 + ($generatedResources == null ? 43 : ((Object)$generatedResources).hashCode());
        Collection<File> $includedSources = this.getIncludedSources();
        result = result * 59 + ($includedSources == null ? 43 : ((Object)$includedSources).hashCode());
        String $targetFolder = this.getTargetFolder();
        result = result * 59 + ($targetFolder == null ? 43 : $targetFolder.hashCode());
        String $targetFileName = this.getTargetFileName();
        result = result * 59 + ($targetFileName == null ? 43 : $targetFileName.hashCode());
        return result;
    }
}

